C
C------------------------------------------------------
C
C     Problem:    FERMTEMP
C
C     Date:       14.02.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      Y=0.5  
      YQS=0.6
      V=20
      CP=1
      UA=0.2 
      VC=1
      CPC=1
      TCIN=10
      TSET=25
      F0=2 
      KP=15
      TI=100000  
      S0=20
      X0=0.1
      TR0=25
      TC0=10  
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      UM, KS, RHO, RHOC, X, S, TR, TC, INTG, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION XP
      U=UM*S/(KS+S)   
      XP=U*X  
C
*     FUNCTION SP
      SP=-U*X/Y  
C 
*     FUNCTION TRP
      RQ=U*X*YQS/Y  
      RC=UA*(TR-TC)   
      TRP=(RQ-RC)/(V*RHO*CP)  
C
*     FUNCTION TCP
      E=TR-TSET   
      F=F0+KP*E+(KP/TI)*INTG
      IF (F.LT.0.0) THEN
        F=0
      ENDIF
      TCP=(F/VC)*(TCIN-TC)+(UA/(VC*RHOC*CPC))*(TR-TC) 
C
*     FUNCTION INTGP
      INTGP=E
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION X_0
      X_0=X0
C
*     FUNCTION S_0
      S_0=S0
C
*     FUNCTION TR_0
      TR_0=TR0
C
*     FUNCTION TC_0
      TC_0=TC0
C
*     FUNCTION INTG_0
      INTG_0=0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION X_fit
      X_fit=X
C
*     FUNCTION S_fit
      S_fit=S
C
*     FUNCTION TR_fit
      TR_fit=TR
C
*     FUNCTION TC_fit
      TC_fit=TC
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G
C      G = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

