C
C------------------------------------------------------
C
C     Problem:    FERMPROC
C
C     Date:       01.12.2003
C
C------------------------------------------------------
C         
*     REAL CONSTANT
      S_in = 100
C
C------------------------------------------------------
C         
*     CONINT D
        0.0   0.3
       50.0   0.2
      130.0   0.3
C
C------------------------------------------------------
C         
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      Yxs, Yps, Ks, mue_max, X, S, P, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION X_t        
      mue = mue_max*S/(Ks + S)
      X_t = (mue - D(t))*X
C
*     FUNCTION S_t
      S_t = -mue/Yxs*X - D(t)*(S - S_in)
C
*     FUNCTION P_t
      P_t = Yps/Yxs*mue*X - D(t)*P
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION X_0     
      if (t.lt.1) then  
        X_0 = 4.5    
      else  
        X_0 = X
      endif  
C
*     FUNCTION S_0
      if (t.lt.1) then  
        S_0 = 10
      else  
        S_0 = S
      endif  
C
*     FUNCTION P_0
      if (t.lt.1) then  
        P_0 = 50
      else  
        P_0 = P
      endif  
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION X_fit
      X_fit = X
C
*     FUNCTION S_fit
      S_fit = S
C
*     FUNCTION P_fit
      P_fit = P
C
*     FUNCTION D_rate
      D_rate = D(t)
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
