C
C------------------------------------------------------
C
C     Problem:    FERMNT
C
C     Date:       09.06.97
C
C------------------------------------------------------
C
*     REAL CONSTANT
      S1_0   = 10
      t_sprung = 4.5
C
C------------------------------------------------------
C
*     LININT F1
      0.0     0.0
      3.5     0.0
      10.0    0.195
C
*     LININT F2
      0.0     0.0
      3.0     0.0
      4.0     0.00804
      4.5     0.01385
      5.0     0.02130
      5.5     0.03088
      6.0     0.04317
      6.5     0.05895
      7.0     0.07922
      7.5     0.10524
      8.0     0.13866
      8.5     0.18156
      9.0     0.23666
      9.5     0.30740
      10.0    0.39823
C
C------------------------------------------------------
C
*     MACRO F3
      if (t.lt.t_sprung) then
        F3 = 0.0
      else
        F3 = 0.1
      endif 
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. concentration variable, if exists (c)
C     3. time variable (t)
C
*     VARIABLE
      muemax1, ks1 , const , muemax2 , ks2 , X1 
      S1 , V1 , X2 , S2 , V2 , X3 , S3 , V3 , t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION dX1_t
      mue = muemax1*S1/(ks1 + S1) - const
      dX1_t = mue*X1 - F1(t)/V1*X1
C
*     FUNCTION dS1_t
      mue = muemax1*S1/(ks1 + S1) - const
      yxs = muemax2*mue/(ks2 + mue)
      dS1_t = (S1_0 - S1) * F1(t)/V1 - mue*X1/yxs
C
*     FUNCTION dV1_t
      dV1_t = F1(t)
C
*     FUNCTION dX2_t
      mue = muemax1*S2/(ks1 + S2) - const
      dX2_t = mue*X2 - F2(t)/V2*X2
C
*     FUNCTION dS2_t
      mue = muemax1*S2/(ks1 + S2) - const
      yxs = muemax2*mue/(ks2 + mue)
      dS2_t = (S1_0 - S2) * F2(t)/V2 - mue*X2/yxs
C
*     FUNCTION dV2_t
      dV2_t = F2(t)
C
*     FUNCTION dX3_t
      mue = muemax1*S3/(ks1 + S3) - const
      dX3_t = mue*X3 - F3/V3*X3
C
*     FUNCTION dS3_t
      mue = muemax1*S3/(ks1 + S3) - const
      yxs = muemax2*mue/(ks2 + mue)
      dS3_t = (S1_0 - S3) * F3/V3 - mue*X3/yxs
C
*     FUNCTION dV3_t
      dV3_t = F3
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION X01
      if (t.lt.1) then
        X01 = 0.066
      else
        X01 = X1
      endif 
C
*     FUNCTION S01
      if (t.lt.1) then
        S01 = 1.83
      else
        S01 = S1
      endif 
C
*     FUNCTION V01
      if (t.lt.1) then
        V01 = 1.0
      else
        V01 = V1
      endif 
C
*     FUNCTION X02
      if (t.lt.1) then
        X02 = 0.05
      else
        X02 = X2
      endif 
C
*     FUNCTION S02
      if (t.lt.1) then
        S02 = 2.83
      else
        S02 = S2
      endif 
C
*     FUNCTION V02
      if (t.lt.1) then
        V02 = 1.0
      else
        V02 = V2
      endif 
C
*     FUNCTION X03
      if (t.lt.1) then
        X03 = 0.033
      else
        X03 = X3
      endif 
C
*     FUNCTION S03
      if (t.lt.1) then
        S03 = 0.83
      else
        S03 = S3
      endif 
C
*     FUNCTION V03
      if (t.lt.1) then
        V03 = 1.0
      else
        V03 = V3
      endif 
c      V03 = 1.0
C
C------------------------------------------------------
C
C   - Fitting criterion:
C
*     FUNCTION XFIT1
      XFIT1 = X1
C
*     FUNCTION SFIT1
      SFIT1 = S1
C
*     FUNCTION XFIT2
      XFIT2 = X2
C
*     FUNCTION SFIT2
      SFIT2 = S2
C
*     FUNCTION XFIT3
      XFIT3 = X3
C
*     FUNCTION SFIT3
      SFIT3 = S3
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

