C
C------------------------------------------------------
C
C     Problem:    FRMENT
C
C     Date:       11.12.98
C
C------------------------------------------------------
C
*     REAL CONSTANTS
      Ko = 0.55D-3 
      Ks = 2.5     
      Ys = 0.9891  
      Yo = 0.890   
      K1a = 180.0  
      Evl = 117.7D+3
      Ekl = 127.0D+3
      Ekp = 72.69D+3
      Emu1 = 6.55D+4 
      Emu2 = -4.62D+4
      pH = 5.6
      Temp1 = 28.3
      R = 8314D-3
      area = 0
      x20=0
      x30=0
C
C------------------------------------------------------
C
*     LININT Avl
      5.4 4.834
      5.8 3.396D+1
      6.2 5.292D+1
      6.6 3.396D+1
      7.0 1.522D+1 
C
*     LININT Akl
      5.4 0D+0
      5.8 962.1D+21
      6.2 470.7D+21
      6.6 290.4D+21
      7.0 138.6D+21
C
*     LININT Akp
      5.4 1.148D+12
      5.8 2.178D+12
      6.2 2.950D+12
      6.6 3.583D+12
      7.0 4.356D+12
C
*     LININT Amu1
      5.4 4.129
      5.8 4.719
      6.2 5.899
      6.6 6.489
      7.0 7.079
C
*     LININT Amu2
      5.4 3.125D-9
      5.8 3.572D-9
      6.2 4.465D-9
      6.6 4.911D-9
      7.0 5.357D-9
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      x10, x40, x50, x1, x2, x3, x4, x5, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION dx1
      IF (Temp1.LE.32) THEN
        mu = Amu1(pH)*exp(10*log(10)-Emu1/(R*(Temp1+273)))
      ELSE 
        mu = Amu2(pH)*exp(-Emu2/(R*(Temp1+273)))
      ENDIF
      vl = Avl(pH)*exp(20*log(10)-Evl/(R*(Temp1+273)))
      K1 = Akl(pH)*exp(-Ekl/(R*(Temp1+273)))
      Kp = Akp(pH)*exp(-Ekp/(R*(Temp1+273)))
      Vaux1v = (x1*x4*x5)/(Ks*x5+Ko*x4+x4*x5)
      Vaux2v = (x1*x4)/(K1a+x4)
      dx1 = mu*Vaux1v
C
*     FUNCTION dx2
      dx2 = vl*Vaux2v - 0.9082*Kp*x2
C
*     FUNCTION dx3
      dx3 = Kp*x2
C
*     FUNCTION dx4
      dx4 = (-1/Ys)*mu*Vaux1v - 1.011*Vaux2v
C
*     FUNCTION dx5
      dx5 = K1*(x50-x5) - (1/Yo)*mu*Vaux1v - 0.09*vl*Vaux2v
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x1_0
      x1_0 = x10
C
*     FUNCTION x2_0
      x2_0 = x20
C
*     FUNCTION x3_0
      x3_0 = x30
C
*     FUNCTION x4_0
      x4_0 = x40
C
*     FUNCTION x5_0
      x5_0 = x50
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION x1_fit
      x1_fit = x1
C
*     FUNCTION x2_fit
      x2_fit = x2
C
*     FUNCTION x3_fit
      x3_fit = x3
C
*     FUNCTION x4_fit
      x4_fit = x4
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C



