C
C------------------------------------------------------
C
C     Problem:    FED_BATE
C
C     Date:       22.12.97
C
C------------------------------------------------------
C
*     REAL CONSTANT
      X0 = 1
      S0 = 50
C
C------------------------------------------------------
C
*     CONINT V
      6.5   3.5
      9.0   0.0
      10.0  5.0
      11.0  0.0
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      muem, mueD, YXS, KS, X, S, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION X_t
      mue = muem*S/(KS + S)
      X_t = mue*X - mueD*X
C
*     FUNCTION S_t
      S_t = -mue*X/YXS + V(t)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION X_0
      IF (t.LT.0.001) THEN
        X_0 = X0
      ELSE
        X_0 = X
      ENDIF
C
*     FUNCTION S_0
      IF (t.LT.0.001) THEN
        S_0 = S0
      ELSE
        S_0 = S
      ENDIF
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION X_fit
      X_fit = X
C
*     FUNCTION S_fit
      S_fit = S
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C



