C
C------------------------------------------------------
C
C     Problem:    FEDBATCH
C
C     Date:       27.01.1997
C
C------------------------------------------------------
C
*     REAL CONSTANT
      K_As21 = 1.0E-10
      mue_Nu1m = 0.0592
      K_Nu1 = 0.0723
      mue_Nu2m = 0.0325
      K_Nu22 = 0.605E-2
      K_Nu21 = 1.0E-11
      K_NuAs = 0.152
      mue_Em = 0.05
      K_EC = 0.2
      mue_E0 = 0
      mue_phim = 0.032
      K_phiAs = 0.953E-3
      mue_W1m = 4.85E-3
      K_WAs = 1.73E-2
      mue_W2m = 3.3E-2
      K_WNu = 1.4E-3
      mue_zWm = 2.74E8
      K_zW1 = 7.87E-1
      K_zW2 = 8.83E3
      Y_AsNu = 0.0972
      Y_AsU = 0.737
      Y_AsPr = 0.188
      Y_AAs = 0.192
      Y_PhNu = 0.327
      Y_CAs = 0.709
      Y_CNu = 1.35
      T = 300.0
      pH = 6.0
      g_x = 1.0
      Q_a = 0.03125
      c_Ae = 1.0
      c_Phe = 1.0
      c_Ce = 1.0
C
C------------------------------------------------------
C
*     CONINT Q_Ae
      94.5   123.0
      95.0   0.0
      165.0 0.0 
C
*     CONINT Q_Phe
      0.0  0.0 
C
*     CONINT Q_Ce
      99.0  250.0
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. concentration variable, if exists (c)
C     3. time variable (t)
C
*     VARIABLE
      mue_Dm, K_DAs, mue_Rm, K_RNu, K_RG, K_G, mue_zRm
      K_zR, mue_Prm, K_PrAs, K_PrNu, mue_zPrm, K_zPr
      mue_Um, K_UAs, K_UI, K_UNu, mue_As1m, K_As1
      mue_As2m, K_As22, mue_AsNu, K_AsNu, K_AsC, K_AsPh
      m_D, m_R, m_Pr, m_As, m_Nu, m_U, m_A, m_Ph, m_C
      m_W, phi, V
      time
C
C------------------------------------------------------
C
C   - Right-hand side:
C
*     FUNCTION m_D_t
C
      m_x = m_D + m_R + m_Pr + m_U + m_As + m_Nu
      V_x = m_x/g_x
      c_A = m_A/V
      c_R = m_R/V
      c_Ph = m_Ph/V
      c_C = m_C/V
      c_x = m_x/V
      c_D = m_D/V
      c_Pr = m_Pr/V
      c_W = m_W/V
      c_As = m_As/V
      c_Nu = m_Nu/V
      g_A = m_A/V_x
      g_R = m_R/V_x
      g_Ph = m_Ph/V_x
      g_C = m_C/V_x
      g_D = m_D/V_x
      g_Pr = m_Pr/V_x
      g_W = m_W/V_x
      g_As = m_As/V_x
      g_Nu = m_Nu/V_x
      mue_D = mue_Dm*g_As/(g_As + K_DAs)*g_Nu/(g_Nu + K_PrNu)
     /        *g_R*g_D*phi
      mue_R = mue_Rm*g_Nu*g_D/(g_Nu + K_RNu + 
     /        K_RG*K_G/(K_G + g_As)*g_R)
      mue_zR = mue_zRm*K_zR/(K_zR + c_A)*g_R
      mue_Pr = mue_Prm*g_As/(g_As + K_PrAs)
     /         *g_Nu/(g_Nu + K_PrNu)*g_R
      mue_zPr = mue_zPrm*K_zPr/(K_zPr + c_A)*g_Pr
      h_As = c_C/(c_C + K_AsC)*(1 + mue_AsNu*
     /       g_Nu/(K_AsNu + g_Nu))*g_Pr/(1 + c_Ph**3*K_AsPh)  
      mue_As = (mue_As1m*c_A/(c_A + K_As1)
     /         + mue_As2m*c_A**4/(c_A**4 + K_As21)
     /           *K_As22/(K_As22 + c_A))*h_As
      h_Nu = g_As/(g_As + K_NuAs)*g_Pr
      mue_Nu = (mue_Nu1m*c_Ph/(c_Ph + K_Nu1) 
     /     + mue_Nu2m*c_Ph**4/(c_Ph**4 + K_Nu21)
     /        *K_Nu22/(K_Nu22 + c_Ph))*h_Nu
      mue_U = mue_Um*g_As/(g_As + K_UAs + g_As**2/K_UI 
     /         + K_UNu*g_Nu)*g_Pr
      mue_E = (mue_Em*c_C/(c_C + K_EC) + mue_E0)*g_x
      mue_W = (mue_W1m*K_WAs/(K_WAs+g_As) 
     /         + mue_W2m*K_WNu/(K_WNu + g_Nu))*g_D
      mue_zW = mue_zWm*exp(K_zW1*pH - K_zW2/T)*c_W
      m_D_t = -Q_a/V*m_D + V_x*mue_D
C
*     FUNCTION m_R_t
      m_R_t = -Q_a/V*m_R + V_x*(mue_R - mue_zR)
C
*     FUNCTION m_Pr_t
      m_Pr_t = -Q_a/V*m_Pr + V_x*(mue_Pr - mue_zPr)
C
*     FUNCTION m_As_t
      m_As_t = -Q_a/V*m_As + V_x*(-mue_Pr + mue_As 
     /   - Y_AsNu*mue_Nu - Y_AsU*mue_U + Y_AsPr*mue_zPr)
C
*     FUNCTION m_Nu_t
      m_Nu_t = -Q_a/V*m_Nu + V_x*(-mue_D - mue_R + mue_Nu
     /    + mue_zR)
C
*     FUNCTION m_U_t
      m_U_t = -Q_a/V*m_U + V_x*(mue_U + (1 - Y_AsPr)*mue_zPr)
C
*     FUNCTION m_A_t
      m_A_t = Q_Ae(time)*c_Ae - Q_a/V*m_A - V_x*Y_AAs*mue_As
C
*     FUNCTION m_Ph_t
      m_Ph_t = Q_Phe(time)*c_Phe - Q_a/V*m_Ph 
     /        - V_x*Y_PhNu*mue_Nu
C
*     FUNCTION m_C_t
      m_C_t = Q_Ce(time)*c_Ce - Q_a/V*m_C - mue_E*V_x 
     /        + V_x*(-Y_CAs*mue_As - Y_CNu*mue_Nu 
     /        + (Y_AsU - 1)*mue_U)
C
*     FUNCTION m_W_t
      m_W_t = -Q_a/V*m_W + V_x*mue_W - V*mue_zW
C
*     FUNCTION phi_t
      phi_t = -mue_phim*K_phiAs/(K_phiAs + g_As)*phi
C
*     FUNCTION V_t
      V_t = Q_Ce(time) + Q_Ae(time) + Q_Phe(time) - Q_a
C
C------------------------------------------------------
C
C   - Initial conditions:
C
*     FUNCTION m_D_0
      IF (time.lt.1) THEN
        m_D_0 = 0.65
      ELSE
        m_D_0 = m_D
      ENDIF 
C
*     FUNCTION m_R_0
      IF (time.lt.1) THEN
        m_R_0 = 1.7     
      ELSE
        m_R_0 = m_R
      ENDIF 
C
*     FUNCTION m_Pr_0
      IF (time.lt.1) THEN
        m_Pr_0 = 8.7
      ELSE
        m_Pr_0 = m_Pr
      ENDIF 
C
*     FUNCTION m_As_0
      IF (time.lt.1) THEN
        m_As_0 = 0.25
      ELSE
        m_As_0 = m_As
      ENDIF 
C
*     FUNCTION m_Nu_0
      IF (time.lt.1) THEN
        m_Nu_0 = 0.13
      ELSE
        m_Nu_0 = m_Nu
      ENDIF 
C
*     FUNCTION m_U_0
      IF (time.lt.1) THEN
        m_U_0 = 1.9
      ELSE
        m_U_0 = m_U
      ENDIF 
C
*     FUNCTION m_A_0
      IF (time.lt.1) THEN
        m_A_0 = 38.0
      ELSE
        m_A_0 = m_A
      ENDIF 
C
*     FUNCTION m_Ph_0
      IF (time.lt.1) THEN
        m_Ph_0 = 16.0
      ELSE
        m_Ph_0 = m_Ph
      ENDIF 
C
*     FUNCTION m_C_0
      IF (time.lt.1) THEN
        m_C_0 = 1988.0
      ELSE
        m_C_0 = m_C
      ENDIF 
C
*     FUNCTION m_W_0
      IF (time.lt.1) THEN
        m_W_0 = 0.0
      ELSE
        m_W_0 = m_W
      ENDIF 
C
*     FUNCTION phi_0
      IF (time.lt.1) THEN
        phi_0 = 1.0
      ELSE
        phi_0 = phi
      ENDIF 
C
*     FUNCTION V_0
      IF (time.lt.1) THEN
        V_0 = 50.0
      ELSE
        V_0 = V
      ENDIF 
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION c_A_fit
      m_x = m_D + m_R + m_Pr + m_U + m_As + m_Nu
      c_A = m_A/V
      c_R = m_R/V
      c_Ph = m_Ph/V
      c_C = m_C/V
      c_x = m_x/V
      c_D = m_D/V
      c_Pr = m_Pr/V
      c_W = m_W/V
      c_As = m_As/V
      c_Nu = m_Nu/V
C
      c_A_fit = c_A
C
*     FUNCTION c_Ph_fit
      c_Ph_fit = c_Ph
C
*     FUNCTION c_C_fit
      c_C_fit = c_C
C
*     FUNCTION c_X_fit
      c_X_fit = c_x
C
*     FUNCTION c_D_fit
      c_D_fit = c_D
C
*     FUNCTION c_R_fit
      c_R_fit = c_R
C
*     FUNCTION c_Pr_fit
      c_Pr_fit = c_Pr
C
*     FUNCTION c_W_fit
      c_W_fit = c_W
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


