C
C------------------------------------------------------
C
C     Problem:    FEDBAT
C
C     Date:       11.06.98
C
C------------------------------------------------------
C
*     REAL CONSTANT
      UM = 0.3
      KS = 0.1
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      K1, K2, Y, SF, X, S, P, V, F, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C  
*     FUNCTION VXP
      U=UM*S/(KS+S)
      RX=U*X
      VXP=RX*V
C 
*     FUNCTION VSP
      RS=-RX/Y
      VSP=F*SF+RS*V
C
*     FUNCTION VPP
      RP=(K1+K2*U)*X
      VPP=RP*V
C
*     FUNCTION VA
      VA=F
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION X0
      X0=0.01
C
*     FUNCTION S0
      S0=10
C
*     FUNCTION P0
      P0=0
C
*     FUNCTION V0
      V0=1
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION XFIT
      XFIT=X
C
*     FUNCTION SFIT
      SFIT=S
C
*     FUNCTION PFIT
      PFIT=P
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


