C
C------------------------------------------------------
C
C     Problem:    FED10
C
C     Date:       16.07.2001
C
C------------------------------------------------------
C
*     CONINT u1
      0.0000  0.0
      2.9631  0.0074 
      3.9543  0.0318
      5.0349  0.0061
      6.0523  0.374
      7.0543  0.0251
      7.9982  0.1282
      8.3082  0.3135
      8.4684  1.0
      8.6644  0.0
      10.000  0.0
C
*     CONINT u2
      0.0000  0.0
      2.9631  0.0055
      3.9543  0.0108
      5.0349  0.0093
      6.0523  0.0143
      7.0543  0.0305
      7.9982  0.0931
      8.3082  0.1320
      8.4684  0.3314
      8.6644  1.0
      10.000  0.0
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      mue1, mue2, RfP1, RfP2
      x1, x2, x3, x4, x5, x6, x7, x8, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x1_t
      x1_t = u1(t) + u2(t)
C
*     FUNCTION x2_t
      beta = 0.108 + x3 + (x3**2/14814.8)
      mue = mue1*x3/beta*(x6 + mue2/(mue2 + x5))
      alpha = (u1(t) + u2(t))/x1
      x2_t = mue*x2 - alpha*x2
C
*     FUNCTION x3_t
      x3_t = 100*u1(t)/x1 - alpha*x3 - mue*x2/0.51
C
*     FUNCTION x4_t
      RfP = (RfP1*x3/beta)*((RfP2 + x5)/(0.022 + x5))
      x4_t = RfP*x2 - alpha*x4
C
*     FUNCTION x5_t
      x5_t = 4*u2(t)/x1 - alpha*x5
C
*     FUNCTION x6_t
      k1 = 0.09*x5/(0.034 + x5)
      x6_t = -k1*x6
C
*     FUNCTION x7_t
      k2 = k1
      x7_t = k2*(1 - x7)
C
*     FUNCTION x8_t
      x8_t = u2(t)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x1_0
      if (t.lt.0.0001) then
        x1_0 = 1
      else
        x1_0 = x1
      endif
C
*     FUNCTION x2_0
      if (t.lt.0.0001) then
        x2_0 = 0.1
      else
        x2_0 = x2
      endif
C
*     FUNCTION x3_0
      if (t.lt.0.0001) then
        x3_0 = 40
      else
        x3_0 = x3
      endif
C
*     FUNCTION x4_0
      if (t.lt.0.0001) then
        x4_0 = 0
      else
        x4_0 = x4
      endif
C
*     FUNCTION x5_0
      if (t.lt.0.0001) then
        x5_0 = 0
      else
        x5_0 = x5
      endif
C
*     FUNCTION x6_0
      if (t.lt.0.0001) then
        x6_0 = 1
      else
        x6_0 = x6
      endif
C
*     FUNCTION x7_0
      if (t.lt.0.0001) then
        x7_0 = 0
      else
        x7_0 = x7
      endif
C
*     FUNCTION x8_0
      if (t.lt.0.0001) then
        x8_0 = 0
      else
        x8_0 = x8
      endif
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION x1_fit
      x1_fit = x1
C
*     FUNCTION x2_fit
      x2_fit = x2
C
*     FUNCTION x3_fit
      x3_fit = x3
C
*     FUNCTION x4_fit
      x4_fit = x4
C
*     FUNCTION x5_fit
      x5_fit = x5
C
*     FUNCTION x6_fit
      x6_fit = x6
C
*     FUNCTION x7_fit
      x7_fit = x7
C
*     FUNCTION x8_fit
      x8_fit = x8
C
*     FUNCTION u1_fit
      u1_fit = u1(t)
C
*     FUNCTION u2_fit
      u2_fit = u2(t)
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C




