C
C------------------------------------------------------
C
C     Problem:    FC_EVAP
C
C     Date:       14.03.2003
C
C------------------------------------------------------
C
*     REAL CONSTANT
      P100 = 194.7     
      F200 = 208                   
      T200 = 25
      T1 = 40
      X1 = 5
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      F1, F2, F3, L2, X2, P2, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION L2_t
      T2 = 0.5616*P2 + 0.3126*X2 + 48.43
      T3 = 0.507*P2 + 55     
      T100 = 0.1538*P100 + 90
      Q100 = 0.15*(F1 + F3)*(T100 - T2)
      F100 = Q100/36.6
      F4 = (Q100 - 0.07*F1*(T2 - T1))/38.5                   
      Q200 = 0.9576*F200*(T3 - T200)/(0.14*F200 + 6.84)
      F5 = Q200/38.5
      L2_t = (F1 - F4 - F2)/20
C
*     FUNCTION X2_t
      X2_t = (F1*X1 - F2*X2)/20
C
*     FUNCTION P2_t
      P2_t = (F4 - F5)/4
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION L2_0
      L2_0 = 1
C
*     FUNCTION X2_0
      X2_0 = 20
C
*     FUNCTION P2_0
      P2_0 = 50
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION L2_fit
      L2_fit = L2
C
*     FUNCTION X2_fit
      X2_fit = X2
C
*     FUNCTION P2_fit
      P2_fit = P2
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
