C
C------------------------------------------------------
C
C     Problem:    FBR
C
C     Date:       14.02.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      V=33
      VT=120
      F=50
      S0=300
      CLS=10
      KS=10
      KO=2
      YOS=2
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      FR, KLA, VM, CL1, CL2, CL3, CL, S1, S2, S3, S, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION CL1P
      TAU=FR/V
      RS1=VM*(S1/(KS+S1))*(CL1/(KO+CL1))  
      RO1=RS1*YOS 
      CL1P=TAU*(CL-CL1)-RO1   
C
*     FUNCTION CL2P
      RS2=VM*(S2/(KS+S2))*(CL2/(KO+CL2))
      RO2=RS2*YOS 
      CL2P=TAU*(CL1-CL2)-RO2  
C
*     FUNCTION CL3P
      RS3=VM*(S3/(KS+S3))*(CL3/(KO+CL3))  
      RO3=RS3*YOS
      CL3P=TAU*(CL2-CL3)-RO3  
C
*     FUNCTION CLP
      CLP=(FR/VT)*(CL3-CL)+KLA*(CLS-CL)   
C
*     FUNCTION S1P
      S1P=TAU*(S-S1)-RS1  
C
*     FUNCTION S2P
      S2P=TAU*(S1-S2)-RS2 
C
*     FUNCTION S3P
      S3P=TAU*(S2-S3)-RS3 
C
*     FUNCTION SP
      SP=(FR/VT)*(S3-S)+(F/VT)*(S0-S) 
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION CL1_0
      CL1_0=0
C
*     FUNCTION CL2_0
      CL2_0=0
C
*     FUNCTION CL3_0
      CL3_0=0
C
*     FUNCTION CL_0
      CL_0=0
C
*     FUNCTION S1_0
      S1_0=0
C
*     FUNCTION S2_0
      S2_0=0
C
*     FUNCTION S3_0
      S3_0=0
C
*     FUNCTION S_0
      S_0=0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION CL1_fit
      CL1_fit=CL1
C
*     FUNCTION CL2_fit
      CL2_fit=CL2
C
*     FUNCTION CL3_fit
      CL3_fit=CL3
C
*     FUNCTION CL_fit
      CL_fit=CL
C
*     FUNCTION S1_fit
      S1_fit=S1
C
*     FUNCTION S2_fit
      S2_fit=S2
C
*     FUNCTION S3_fit
      S3_fit=S3
C
*     FUNCTION S_fit
      S_fit=S
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G
C      G = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

