C
C------------------------------------------------------
C
C     Problem:    FAST
C
C     Date:       16.01.00
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      a, k1, k2, y20, y1, y2, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION y1_t
      y1_t = -a*y1 + y2 + a*sin(t)
C
*     FUNCTION y2_t
      y2_t = k1*y1 - k2*y2 + k2*(cos(t) - sin(t))
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION y1_0
      y1_0 = 2
C
*     FUNCTION y2_0
      y2_0 = -y20
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION y1_fit
c      y1_fit = exp(-t) + exp(-1000*t) + sin(t)
      y1_fit = y1
C
*     FUNCTION y2_fit
c      y2_fit = exp(-t) - 998*exp(-1000*t) + cos(t)
      y2_fit = y2
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
