C
C------------------------------------------------------
C
C     Problem:    EXP_INC
C
C     Date:       09.03.2002
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      p1, p2, y1, y2, y3, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION y1_t
      y1_t = (p2 - p1*cos(p2*t))*y1 + (p2 + p1*sin(p2*t))*y3 
     /       + exp(t)*(-1 + 19*(cos(2*t) - sin(2*t)))
C
*     FUNCTION y2_t
      y2_t = p1*y2 - 18*exp(t)
C
*     FUNCTION y3_t
      y3_t = (-p2 + p1*sin(p2*t))*y1 + (p2 + p1*cos(p2*t))*y3 
     /       + exp(t)*(1 - 19*(cos(2*t) + sin(2*t)))
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION y1_0
      y1_0 = 1
C
*     FUNCTION y2_0
      y2_0 = 1
C
*     FUNCTION y3_0
      y3_0 = 1
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION y1_fit
      y1_fit = y1
c exp(t)
C
*     FUNCTION y2_fit
      y2_fit = y2
c exp(t)
C
*     FUNCTION y3_fit
      y3_fit = y3
c exp(t)
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C



