C
C------------------------------------------------------
C
C     Problem:  EXP_FIT2
C
C     Date:     09.05.93
C
C------------------------------------------------------
C
*     SET OF INDICES
      INDOBS=1..14
C
C------------------------------------------------------
C
*     REAL CONSTANT
      EPS=1.D-12
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. concentration variable, if exists (c)
C     3. time variable (t)
C
*     VARIABLE
      X1, X2, X3, X4, X5, X6, TAU, T
C
C------------------------------------------------------
C
C   - Fitting criteria:
C   
*     FUNCTION F
      X42=X4 - X2
      X32=X3 - X2
      X52=X5 - X2
      X62=X6 - X2
      X43=X4 - X3
      X53=X5 - X3
      X63=X6 - X3
      X45=X4 - X5
      X65=X6 - X5
      X46=X4 - X6
C
      Y1=X32*X52*X62
      Y2=-X32*X53*X63
      Y3=X52*X53*X65
      Y4=-X62*X63*X65
C
      IF (T.LT.TAU) THEN
        F = 0
      ELSE
        F = X1*X2*X3*
     /     (X42/Y1*DEXP(-X2*(T-TAU))
     /    + X43/Y2*DEXP(-X3*(T-TAU))
     /    + X45/Y3*DEXP(-X5*(T-TAU))
     /    + X46/Y4*DEXP(-X6*(T-TAU)))
      ENDIF
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G
C      G = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C



