C
C------------------------------------------------------
C
C     Problem:    EXO_REAC
C
C     Date:       04.06.2002
C
C------------------------------------------------------
C
*     REAL CONSTANT
      R = 8.314
      T = 253
      mC = 1.93E-02
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k10, k20, Eact1, Eact2, lag_time, end_time
      c1, c2, c3, c4, time 
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION c1_t
      if (time.ge.lag_time) then
        c1_t = mC/60
          if (time.ge.end_time) then
            c1_t = 0
          else
            c1_t = mC/60
          endif
      else
        c1_t = 0
      endif
C
*     FUNCTION c2_t
      k1 = k10*exp(-Eact1/(R*T))
      k2 = k20*exp(-Eact2/(R*T))
      if (time.ge.lag_time) then
        c2_t = 0.2/c1*60 - k2*c4*c2 - c1_t*c4/c1
      else
        c2_t = 0
      endif
C
*     FUNCTION c3_t
      if (time.lt.lag_time) then
        c3_t = 0
      else
        c3_t = -k1*c3*c2 - c1_t*c3/c1  
      endif
C             
*     FUNCTION c4_t
      if (time.lt.lag_time) then
        c4_t = 0
      else
        c4_t = k1*c3*c2 + c1_t*c3/c1 - k2*c4*c2 - c1_t*c4/c1
      endif
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION c1_0
      if (time.lt.lag_time) then
        c1_0 = 0.3186
      else
        c1_0 = c1
      endif
C
*     FUNCTION c2_0
      if (time.lt.lag_time) then
        c2_0 = 0
      else
        c2_0 = c2
      endif
C
*     FUNCTION c3_0
      if (time.lt.lag_time) then
        c3_0 = 0.627746 
      else
        c3_0 = c3
      endif
C
*     FUNCTION c4_0
      if (time.lt.lag_time) then
        c4_0 = 0
      else
        c4_0 = c4
      endif
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION c1_fit
      c1_fit = c1
C
*     FUNCTION c2_fit
      c2_fit = c2
C
*     FUNCTION c3_fit
      c3_fit = c3
C
*     FUNCTION c4_fit
      c4_fit = c4
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

