C
C------------------------------------------------------
C
C     Problem:    EXOBATCH
C
C     Date:       15.03.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      Tref = 298
      A1 = 0.008
      A2 = 0.002
      E1 = 3000
      E2 = 2400
      deltaH1 = -100
      deltaH2 = -75
      hf = 20
      rhoA = 11250
      rhoB = 16000
      rhoC = 10400
      rhoD = 10000
      bA = 0.000474
      bB = 0.0005
      bC = 0.00055
      bD = 0.000323
C
C------------------------------------------------------
C
*     CONINT FB
      0.0    10.0
      600.0  10.0     
      900.0  8.0
      1600.0 0.0
C
*     CONINT Q
      0.0    0.0
      500.0  0.0     
      1600.0 1000.0
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. variables identifying solution of corresponding
C        algebraic equations (z)
C     4. concentration variable, if exists (c)
C     5. time variable (t)
C
*     VARIABLE
      aA, aB, aC, aD
      MA, MB, MC, MD, H, CA, CB, CC, CD, TR, V, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION MA_t
      k1 = A1*EXP(-E1/TR)
      r1 = k1*CA*CB
      MA_t = -V*r1
C
*     FUNCTION MB_t
      k2 = A2*EXP(-E2/TR)
      r2 = k2*CB*CC
      MB_t = FB(t) - V*(r1 + r2)
C
*     FUNCTION MC_t
      MC_t = V*(r1 - r2)
C
*     FUNCTION MD_t
      MD_t = V*r2
C
*     FUNCTION H_t
      H_t = FB(t)*hf - Q(t) - V*(r1*deltaH1 + r2*deltaH2)
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     algebraic equations:
C
*     FUNCTION alg_equ1
      alg_equ1 = CA - MA/V
C
*     FUNCTION alg_equ2
      alg_equ2 = CB - MB/V
C
*     FUNCTION alg_equ3
      alg_equ3 = CC - MC/V
C
*     FUNCTION alg_equ4
      alg_equ4 = CD - MD/V
C
*     FUNCTION alg_equ5
      alg_equ5 = H - MA*(aA*(TR - Tref) + 0.5*bA*(TR**2 - Tref**2))
     /             - MB*(aB*(TR - Tref) + 0.5*bB*(TR**2 - Tref**2))
     /             - MC*(aC*(TR - Tref) + 0.5*bC*(TR**2 - Tref**2))
     /             - MD*(aD*(TR - Tref) + 0.5*bD*(TR**2 - Tref**2))
C
*     FUNCTION alg_equ6
      alg_equ6 = V - MA/rhoA - MB/rhoB - MC/rhoC - MD/rhoD   
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION MA_0
      MA_0 = 9000
C
*     FUNCTION MB_0
      MB_0 = 0
C
*     FUNCTION MC_0
      MC_0 = 0
C
*     FUNCTION MD_0
      MD_0 = 0
C
*     FUNCTION H_0
      H_0 = 152.51
C
C------------------------------------------------------
C
C   - Initial values for solving systems of algebraic
C     equations (t=0):
C
*     FUNCTION CA_0
      CA_0 = 0
C
*     FUNCTION CB_0
      CB_0 = 0
C
*     FUNCTION CC_0
      CC_0 = 0
C
*     FUNCTION CD_0
      CD_0 = 0
C
*     FUNCTION TR_0
      TR_0 = Tref
C
*     FUNCTION V_0
      V_0 = 20
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION CA_fit
      CA_fit = CA
C
*     FUNCTION CB_fit
      CB_fit = CB
C
*     FUNCTION CC_fit
      CC_fit = CC
C
*     FUNCTION CD_fit
      CD_fit = CD
C
*     FUNCTION TR_fit
      TR_fit = TR
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

