C
C------------------------------------------------------
C
C     Problem:    EVAPOR
C
C     Date:       27.01.1997
C
C------------------------------------------------------
C
*     REAL CONSTANT
      R = 0.1066
      c_p = 1.26
      lambda = 387.0
      Q = 8201.4
      T_zu = 348.16
      T_0 = 273.16
      m_w = 4370.0
      Vol = 10.0
      rho = 874.0
      k_R = 0.05
      k_V = 7.0179
      p_0 = 2.0
      tau = 50.0
      h_scale = 770000.0
      h0F = 769821.8/h_scale
      h0D = 300.65
C
C------------------------------------------------------
C
*     CONINT x_V
      0.0   0.7
      50.0  0.01
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. variables identifying solution of corresponding
C        algebraic equations (z)
C     4. concentration variable, if exists (c)
C     5. time variable (t)
C
*     VARIABLE
      A, B, C
      m, zeta, c1
      m_F, m_D, h_F, h_D, f_zu, f_ab, T, p, h, sv
      time
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION m_t
      m_t = f_zu - f_ab
C
*     FUNCTION zeta_t
      zeta_t = (f_zu*c_p*(T_zu - T_0) - f_ab*c_p*(T - T_0) 
     /         - f_ab*lambda + Q)/h_scale
C
*     FUNCTION c1_t
      c1_t = m_w - m_F
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     algebraic equations:
C
*     FUNCTION a1
      a1 = m_F + m_D - m
C
*     FUNCTION a2
      a2 = (h_F*h_scale + h_D - h*h_scale)/h_scale
C
*     FUNCTION a3
      a3 = (m_F*c_p*(T - T_0) - h_F*h_scale)/h_scale
C
*     FUNCTION a4
      a4 = m_D*c_p*(T - T_0) + m_D*lambda - h_D
C
*     FUNCTION a5
      a5 = Vol - m_F/rho - m_D*sv
C
*     FUNCTION a6
      a6 = m_D*R*T - p*sv
C
*     FUNCTION a7
      a7 = exp(A-B/(T+C)) - p
C
*     FUNCTION a8
      a8 = k_R*((m_w - m_F) + c1/tau) - f_zu
C
*     FUNCTION a9
      IF (p.GT.p_0) THEN
        a9 = k_V*x_V(time)*sqrt(abs(p*(p - p_0))) - f_ab
      ELSE
        IF (p.EQ.p_0) THEN
          a9 = -f_ab
      ELSE
          a9 = -k_V*x_V(time)*sqrt(abs(p*(p_0 - p))) - f_ab      
         ENDIF
      ENDIF
C
*     FUNCTION a10
      a10 = (h*h_scale - p*Vol - zeta*h_scale)/h_scale
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION m0
      IF (time.lt.1) THEN
        m0 = 4370.5339
      ELSE
        m0 = m
      ENDIF
C
*     FUNCTION zeta0
      IF (time.lt.1) THEN
        zeta0 = (h0F*h_scale + h0D - Vol*4.7)/h_scale
      ELSE
        zeta0 = zeta
      ENDIF
C
*     FUNCTION c10
      IF (time.lt.1) THEN
        c10 = 17500.0
      ELSE
        c10 = c1
      ENDIF
C
C------------------------------------------------------
C
C   - Initial values for solving systems of algebraic
C     equations (t=0):
C
*     FUNCTION m0_F
      m0_F = 4370.0
C
*     FUNCTION m0_D
      m0_D = 0.5339
C
*     FUNCTION h0_F 
      h0_F = h0F
C
*     FUNCTION h0_D
      h0_D = h0D
C
*     FUNCTION f0_zu
      f0_zu = 17.5
C
*     FUNCTION f0_ab
      f0_ab = 17.5
C
*     FUNCTION T0
      T0 = 412.96
C
*     FUNCTION p0
      p0 = 4.7
C
*     FUNCTION h0
      h0 = h0F + h0D/h_scale
C
*     FUNCTION sv0
      sv0 = 9.365
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION fab
      fab = f_ab
C
*     FUNCTION m_plot
      m_plot = m
C
*     FUNCTION zeta_plot
      zeta_plot = zeta
C
*     FUNCTION c1_plot
      c1_plot = c1
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C




