C
C------------------------------------------------------
C
C     Problem:    ETHYL1  
C
C     Date:       21.10.00
C
C------------------------------------------------------
C
*     REAL CONSTANT
      De            = 0.457885697  
      v             = 24.68885544  
      M_A           = 28.05  
      M_B           = 30.07  
      M_H           = 2.016  
      M_C           = 16.04  
      P             = 20.04761905         
      sig_A         = 4.163        
      sig_B         = 4.443        
      sig_H         = 2.827        
      sig_C         = 3.758        
      sig_AB        = (sig_A + sig_B)/2  
      sig_AH        = (sig_A + sig_H)/2  
      sig_AC        = (sig_A + sig_C)/2  
      sig_BH        = (sig_B + sig_H)/2  
      sig_BC        = (sig_B + sig_C)/2  
      sig_HC        = (sig_H + sig_C)/2     
      eps_A         = 224.7        
      eps_B         = 215.7        
      eps_H         = 59.7         
      eps_C         = 148.6           
      eps_AB        = SQRT (eps_A * eps_B)  
      eps_AH        = SQRT (eps_A * eps_H)  
      eps_AC        = SQRT (eps_A * eps_C)  
      eps_BH        = SQRT (eps_B * eps_H)  
      eps_BC        = SQRT (eps_B * eps_C)  
      eps_HC        = SQRT (eps_H * eps_C)  
      A             = 1.06036  
      B             = 0.1561   
      C             = 0.193    
      D             = 0.47635  
      E             = 1.03587  
      F             = 1.52996  
      G             = 1.76474  
      HD            = 3.89411   
      AV            = 1.16145  
      BV            = 0.14874  
      CV            = 0.52487  
      DV            = 0.7732   
      EV            = 2.16178  
      FV            = 2.43787  
      x_A             =0.075        
      x_H             =0.3          
      x_B             =0.0          
      porosity      = 0.5  
      a_v           = 15         
      rho_f         = 0.017218   
      rho_s         = 1.28       
      C_pf          = 10/21      
      C_ps          = 0.22  
      DeltaH_r1     = -34000     
      R             = 1.987      
      Tr            = 350  
C
C------------------------------------------------------
C
*     LININT Tf1
      0.0     326.0
      1030.0  343.0
      3800.0  297.0
      7100.0  297.0
C
*     LININT C_Af1
      0.0     0.0000560
      1030.0  0.0000536
      3800.0  0.0000615
      7100.0  0.0000615
C
*     LININT C_H2f1
      0.0     0.000224
      1030.0  0.000214
      3800.0  0.000247
      7100.0  0.000247
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      K_Ars, DeltaH_As, par1s, par2s, C_As, Ts, C_H2s, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION dC_As
      K_Ar = K_Ars*10000
      DeltaH_A = DeltaH_As*10000
      par1 = par1s*10000
      par2 = par2s*1000
      Tf = Tf1(t)
      C_Af = C_Af1(t)
      C_H2f = C_H2f1(t)
      x_C = 1 - x_A - x_H - x_B 
      Mm = M_A * x_A + M_B * x_B + M_H *x_H + M_C * x_C   
      K_A = K_Ar * EXP((-DeltaH_A/R) * ((1/Ts)-(1/Tr)))  
      Tm = (Tf + Ts)/2    
      Cp_A = 2.83  + 28.601E-3 * Tm - 8.726E-6 * Tm**2  
      Cp_B = 2.247 + 38.201E-3 * Tm - 11.049E-6 * Tm**2   
      Cp_H = 6.52  + 0.78E-3 * Tm + 0.12E5  * Tm**(-2)  
      Cp_C = 3.381 + 18.044E-3 * Tm - 4.3E-6 * Tm**2  
      Cpf  = x_A * Cp_A + x_B * Cp_B + x_H * Cp_H + x_C * Cp_C   
      Tst_A = Tm / eps_A  
      Tst_B = Tm / eps_B  
      Tst_H = Tm / eps_H  
      Tst_C = Tm / eps_C   
      Ome_kA = AV * Tst_A**(-BV) + CV * EXP(-DV * Tst_A) + EV
     /         * EXP(-FV * Tst_A)   
      Ome_kB = AV * Tst_B**(-BV) + CV * EXP(-DV * Tst_B) + EV 
     /         * EXP(-FV * Tst_B)   
      Ome_kH = AV * Tst_H**(-BV) + CV * EXP(-DV * Tst_H) + EV 
     /        * EXP(-FV * Tst_H)   
      Ome_kC = AV * Tst_C**(-BV) + CV * EXP(-DV * Tst_C) + EV 
     /        * EXP(-FV * Tst_C)   
      kt_A = 1.9891E-4 * SQRT(Tm/M_A)/(sig_A**2 * Ome_kA)  
      k_B =  1.9891E-4 * SQRT(Tm/M_B)/(sig_B**2 * Ome_kB)  
      k_H =  1.9891E-4 * SQRT(Tm/M_H)/(sig_H**2 * Ome_kH)  
      k_C =  1.9891E-4 * SQRT(Tm/M_C)/(sig_C**2 * Ome_kC)   
      kf  = x_A * kt_A + x_B * k_B + x_H * k_H + x_C * k_C   
      mu_A = 2.6693E-5 * SQRT(M_A*Tm)/(sig_A**2 * Ome_kA)  
      mu_B = 2.6693E-5 * SQRT(M_B*Tm)/(sig_B**2 * Ome_kB)  
      mu_H = 2.6693E-5 * SQRT(M_H*Tm)/(sig_H**2 * Ome_kH)  
      mu_C = 2.6693E-5 * SQRT(M_C*Tm)/(sig_C**2 * Ome_kC)   
      muf  = x_A * mu_A + x_B * mu_B + x_H * mu_H + x_C * mu_C  
      Cf = P/(82.05*Tm)  
      Tst_AB = Tm/eps_AB  
      Tst_AH = Tm/eps_AH  
      Tst_AC = Tm/eps_AC  
      Tst_BH = Tm/eps_BH  
      Tst_BC = Tm/eps_BC  
      Tst_HC = Tm/eps_HC   
      Ome_AB = A/Tst_AB**B + C/EXP(D*Tst_AB) + E/EXP(F*Tst_AB)
     /        + G/EXP(HD*Tst_AB)  
      Ome_AH = A/Tst_AH**B + C/EXP(D*Tst_AH) + E/EXP(F*Tst_AH)
     /        + G/EXP(HD*Tst_AH)  
      Ome_AC = A/Tst_AC**B + C/EXP(D*Tst_AC) + E/EXP(F*Tst_AC) 
     /        + G/EXP(HD*Tst_AC)  
      Ome_BH = A/Tst_BH**B + C/EXP(D*Tst_BH) + E/EXP(F*Tst_BH)
     /        + G/EXP(HD*Tst_BH)  
      Ome_BC = A/Tst_BC**B + C/EXP(D*Tst_BC) + E/EXP(F*Tst_BC)
     /        + G/EXP(HD*Tst_BC)  
      Ome_HC = A/Tst_HC**B + C/EXP(D*Tst_HC) + E/EXP(F*Tst_HC) 
     /        + G/EXP(HD*Tst_HC)   
      D_AB   = 0.0018583*SQRT(Tm**3*((1/M_A)+(1/M_B)))
     /        /(P*sig_AB**2*Ome_AB)            
      D_AH   = 0.0018583*SQRT(Tm**3*((1/M_A)+(1/M_H)))
     /        /(P*sig_AH**2*Ome_AH)            
      D_AC   = 0.0018583*SQRT(Tm**3*((1/M_A)+(1/M_C)))
     /        /(P*sig_AC**2*Ome_AC)            
      D_BH   = 0.0018583*SQRT(Tm**3*((1/M_B)+(1/M_H)))
     /        /(P*sig_BH**2*Ome_BH)            
      D_BC   = 0.0018583*SQRT(Tm**3*((1/M_B)+(1/M_C)))
     /        /(P*sig_BC**2*Ome_BC)            
      D_HC   = 0.0018583*SQRT(Tm**3*((1/M_H)+(1/M_C)))
     /        /(P*sig_HC**2*Ome_HC)             
      D_Am    = (1 - x_A)/((x_H - x_A)/D_AH + (x_B + x_A)/D_AB 
     /          + x_C/D_AC)           
      D_Hm    = (1 - x_H)/((x_A - x_H)/D_AH + (x_B + x_H)/D_BH
     /          + x_C/D_HC)            
      rhof   = Cf *Mm 
      Re   = De * v * rhof /muf 
      Sc_A = muf/(rhof * D_Am) 
      Sc_H = muf/(rhof * D_Hm)           
      Pr   = Cpf * muf/ (kf * Mm)  
      k_cA = (D_Am/De) * (2 + 0.6 * Re**(1/2) * Sc_A**(1/3))
      k_cH = (D_Hm/De) * (2 + 0.6 * Re**(1/2) * Sc_H**(1/3)) 
      h    = (2 + 0.6 * Re**(1/2) * Pr**(1/3))* kf/De                
      Lep_A = h/(Cf * Cpf * k_cA)             
      Lep_H = h/(Cf * Cpf * k_cH)                    
      dC_As = ((C_Af - C_As) * k_cA * a_v - par1* EXP((-par2/R)
     /       * ((1/Ts)-(1/Tr))) * (C_As * C_H2s / (1 + K_A * C_As))) 
     /       / porosity
C
*     FUNCTION dTs
      dTs = (h * a_v * (Tf -Ts) + (-DeltaH_r1) * par1 
     /            * EXP((-par2/R) * ((1/Ts)-(1/Tr)))  
     /            * (C_As * C_H2s / (1 + K_A * C_As)))
     /    / (rho_f * C_pf * porosity + rho_s * C_ps * (1 - porosity))
C
*     FUNCTION dC_H2s
      dC_H2s = ((C_H2f - C_H2s) * k_cH * a_v - par1
     /      * EXP((-par2/R) * ((1/Ts)-(1/Tr))) 
     /      * (C_As * C_H2s / (1 + K_A * C_As)))
     /      / porosity
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
C
*     FUNCTION C_As0
      C_As0 = 5.65314E-05  
C
*     FUNCTION Ts0
      Ts0 = 328.956  
C
*     FUNCTION C_H2s0
      C_H2s0 = 0.000224686  
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION Ts_fit
      Ts_fit = Ts
C
C*     FUNCTION C_As_fit
C      C_As_fit = C_As
C
C*     FUNCTION  C_H2s_fit
C      C_H2s_fit = C_H2s
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C