C
C------------------------------------------------------
C
C     Problem:    ETHFERM
C
C     Date:       03.07.98
C
C------------------------------------------------------
C
*     REAL CONSTANT
      Q = 0.2
      GLU0 = 60
      KP13 = 1.02
      ALPHA = 0.3103
      Y1 = 0.2
      Y2 = 0.1
      Y4 = 0.9
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      K1,K2,K3,K4,K5,KS1,KS2,KS4
      V,GLU,X,ETOH,E0,E1,E2,T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION VP
      VP=Q
C
*     FUNCTION GLUP
      R1=GLU/(GLU+KS1)*K1*ALPHA*X
      R2=GLU/(GLU+KS2)*K2*(1-ALPHA)*X
      GLUP=-(R1+R2)+(Q*GLU0-GLU*Q)/V
C
*     FUNCTION XP
      R3=ETOH/(ETOH+KP13)*K3*E2*X
      XP=Y1*R1+Y2*R2+Y4*R3-X*Q/V
C
*     FUNCTION ETOHP
      Y3=(1-1.05*Y2)/1.25
      ETOHP=Y3*R2-R3-ETOH*Q/V
C
*     FUNCTION E0P
      R4=K4/(KS4+GLU*GLU*GLU)*X*E0
      E0P=-R4-E0*Q/V
C
*     FUNCTION E1P
      R5=K5*X*E1
      E1P=R4-R5-E1*Q/V
C
*     FUNCTION E2P
      E2P=R5-E2*Q/V
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION V0
      V0=5
C
*     FUNCTION GLU1
      GLU1=GLU0
C
*     FUNCTION X0
      X0=0.25
C
*     FUNCTION ETOH0
      ETOH0=0
C
*     FUNCTION E00
      E00=1
C
*     FUNCTION E10
      E10=0
C
*     FUNCTION E20
      E20=0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION GLUFIT
      GLUFIT=GLU
C
*     FUNCTION XFIT
      XFIT=X
C
*     FUNCTION ETOHFIT
      ETOHFIT=ETOH
C
C------------------------------------------------------
C
C
*     END
C
C------------------------------------------------------
C

