C
C------------------------------------------------------
C
C     Problem:    ETHANOL
C
C     Date:       07.11.2000
C
C------------------------------------------------------
C
*     REAL CONSTANT
      s0 = 150
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE 
      mu0, kp, ks, eps0, kpp, ksp, yxs, x, s, p, v, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x_t
      mu = mu0/(1 + p/kp)*s/(ks + s)
      u = (t/15)**2 + 0.25
      x_t = mu*x - u*x/v
C
*     FUNCTION s_t
      s_t = -x*mu/yxs + u*(s0 - s)/v
C
*     FUNCTION p_t
      eps = eps0/(1 + p/kpp)*s/(ksp + s)
      p_t = eps*x - u*p/v
C
*     FUNCTION v_t
      v_t = u
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x_0
      x_0 = 1
C
*     FUNCTION s_0
      s_0 = s0
C
*     FUNCTION p_0
      p_0 = 1
C
*     FUNCTION v_0
      v_0 = 10
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION x_fit
      x_fit = x
C
*     FUNCTION s_fit
      s_fit = s
C
*     FUNCTION p_fit
      p_fit = p
C
*     FUNCTION v_fit
      v_fit = v
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C




