C
C------------------------------------------------------
C
C     Problem:    ESTER_GA
C
C     Date:       9/7/2005
C
C------------------------------------------------------
C
*     SET OF INDICES
      Nc=1..4
C
C------------------------------------------------------
C
*     TABLE r(i), i in Nc
      1 2.2024
      2 3.4543
      3 4.4827
      4 0.9200
C
*     TABLE q(i), i in Nc 
      1 2.072
      2 3.052
      3 4.196
      4 1.400
C
*     TABLE u(i,j), i in Nc, j in Nc
      1 1 0.0
      2 1 -228.304
      3 1 260.69
      4 1 -211.512
      1 2 353.573
      2 2 0.0
      3 2 57.3986
      4 2 418.518
      1 3 -109.692
      2 3 -34.2506
      3 3 0.0
      4 3 230.453
      1 4 374.438
      2 4 -102.258
      3 4 427.621
      4 4 0.0   
C
C------------------------------------------------------
C
*     REAL CONSTANT
      Rg   = 4.18
      Rid  = 8.314
      z    = 10.0
      L(i) = (z/2.0)*(r(i)-q(i))-(r(i)-1), i in Nc
      xa0  = 0.50
      xb0  = 0.50
      Mc   = 6.67
      nt   = 1.0
      Ea   = -440.*Rid
      Temp = 353.15
C
C------------------------------------------------------
C                       
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      kfs, Efs, Ka, x, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x_t
      kf = kfs*100000
      Ef = Efs*100000
      x1 = x
      x2 = xb0 - xa0 + x
      x3 = xa0 - x
      x4 = xa0 - x 
      tau11 = dexp(-4.18*u(1,1)/(Rg*Temp))
      tau12 = dexp(-4.18*u(1,2)/(Rg*Temp))
      tau13 = dexp(-4.18*u(1,3)/(Rg*Temp))
      tau14 = dexp(-4.18*u(1,4)/(Rg*Temp))
      tau21 = dexp(-4.18*u(2,1)/(Rg*Temp))
      tau22 = dexp(-4.18*u(2,2)/(Rg*Temp))
      tau23 = dexp(-4.18*u(2,3)/(Rg*Temp))
      tau24 = dexp(-4.18*u(2,4)/(Rg*Temp))
      tau31 = dexp(-4.18*u(3,1)/(Rg*Temp))
      tau32 = dexp(-4.18*u(3,2)/(Rg*Temp))
      tau33 = dexp(-4.18*u(3,3)/(Rg*Temp))
      tau34 = dexp(-4.18*u(3,4)/(Rg*Temp))
      tau41 = dexp(-4.18*u(4,1)/(Rg*Temp))
      tau42 = dexp(-4.18*u(4,2)/(Rg*Temp))
      tau43 = dexp(-4.18*u(4,3)/(Rg*Temp))
      tau44 = dexp(-4.18*u(4,4)/(Rg*Temp))
      q_sum = q(1)*x1 + q(2)*x2 + x3*q(3) + x4*q(4)
      theta1 = q(1)*x1/(q_sum)
      theta2 = q(2)*x2/(q_sum)
      theta3 = q(3)*x3/(q_sum)
      theta4 = q(4)*x4/(q_sum)
      r_sum = r(1)*x1 + r(2)*x2 + x3*r(3) + x4*r(4)
      phi1 = r(1)/(r_sum)
      phi2 = r(2)/(r_sum)
      phi3 = r(3)/(r_sum)
      phi4 = r(4)/(r_sum)
      l_sum = l(1)*x1 + l(2)*x2 + l(3)*x3 + l(4)*x4
      v1 = (q(1)/r(1))*(r_sum/q_sum)
      v2 = (q(2)/r(2))*(r_sum/q_sum)
      v3 = (q(3)/r(3))*(r_sum/q_sum)
      v4 = (q(4)/r(4))*(r_sum/q_sum)     
      gammaC1 = exp(log(phi1) + L(1) + (z/2.)*q(1)*log(v1) - phi1*l_sum)
      gammaC2 = exp(log(phi2) + L(2) + (z/2.)*q(2)*log(v2) - phi2*l_sum)
      gammaC3 = exp(log(phi3) + L(3) + (z/2.)*q(3)*log(v3) - phi3*l_sum)
      gammaC4 = exp(log(phi4) + L(4) + (z/2.)*q(4)*log(v4) - phi4*l_sum)
      theta_tau1 = theta1*tau11 + theta2*tau21 + theta3*tau31 + theta4*tau41
      theta_tau2 = theta1*tau12 + theta2*tau22 + theta3*tau32 + theta4*tau42
      theta_tau3 = theta1*tau13 + theta2*tau23 + theta3*tau33 + theta4*tau43
      theta_tau4 = theta1*tau14 + theta2*tau24 + theta3*tau34 + theta4*tau44
      theta_tau_sum = theta_tau1 + theta_tau2 + theta_tau3 + theta_tau4
      tau_theta1 = theta1*tau11/theta_tau1+theta2*tau12/theta_tau2
     /             + theta3*tau13/theta_tau3 + theta4*tau14/theta_tau4
      tau_theta2 = theta1*tau21/theta_tau1 + theta2*tau22/theta_tau2
     /             + theta3*tau23/theta_tau3 + theta4*tau24/theta_tau4
      tau_theta3 = theta1*tau31/theta_tau1 + theta2*tau32/theta_tau2
     /             + theta3*tau33/theta_tau3 + theta4*tau34/theta_tau4
      tau_theta4 = theta1*tau41/theta_tau1 + theta2*tau42/theta_tau2
     /             + theta3*tau43/theta_tau3 + theta4*tau44/theta_tau4
      gammaR1 = exp(q(1)*(1-log(theta_tau1) - tau_theta1))
      gammaR2 = exp(q(2)*(1-log(theta_tau2) - tau_theta2))
      gammaR3 = exp(q(3)*(1-log(theta_tau3) - tau_theta3))
      gammaR4 = exp(q(4)*(1-log(theta_tau4) - tau_theta4))
      a1 = x1*gammaC1*gammaR1
      a2 = x2*gammaC2*gammaR2
      a3 = x3*gammaC3*gammaR3
      a4 = x4*gammaC4*gammaR4
      K1 = Kf*dexp(-Ef/(Rid*Temp))
      K2 = Ka*dexp(-Ea/(Rid*Temp))
      x_t = -(Mc/nt)*K1*(a1*a2  -   a3*a4/K2 ) 
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x_0
      x_0 = 0.5
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION x_fit
      x_fit = x
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = x 
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
