C
C------------------------------------------------------
C
C     Problem:    EQMULTI
C
C     Date:       12.02.01
C
C------------------------------------------------------
C 
*     REAL CONSTANT
      V1=2
      V2=2          
      X0=1
      Y6=0       
      M=0.8
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      L0, G, K, X1, X2, X3, X4, X5, Y1, Y2, Y3, Y4, Y5, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION X1P
      IF (T.LT.3) THEN
        L=L0
      ELSE
        L=10*L0
      ENDIF
      Q1=K*(X1-Y1/M)  
      Q2=K*(X2-Y2/M)  
      Q3=K*(X3-Y3/M)  
      Q4=K*(X4-Y4/M)  
      Q5=K*(X5-Y5/M)  
      X1P=(L*(X0-X1)-Q1)/V1   
C
*     FUNCTION X2P
      X2P=(L*(X1-X2)-Q2)/V1   
C
*     FUNCTION X3P
      X3P=(L*(X2-X3)-Q3)/V1   
C
*     FUNCTION X4P
      X4P=(L*(X3-X4)-Q4)/V1   
C
*     FUNCTION X5P
      X5P=(L*(X4-X5)-Q5)/V1   
C
*     FUNCTION Y1P
      Y1P=(G*(Y2-Y1)+Q1)/V2   
C
*     FUNCTION Y2P
      Y2P=(G*(Y3-Y2)+Q2)/V2   
C
*     FUNCTION Y3P
      Y3P=(G*(Y4-Y3)+Q3)/V2   
C
*     FUNCTION Y4P
      Y4P=(G*(Y5-Y4)+Q4)/V2   
C
*     FUNCTION Y5P
      Y5P=(G*(Y6-Y5)+Q5)/V2   
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION X1_0
      IF (T.LT.0.1) THEN
        X1_0=0
      ELSE
        X1_0=X1
      ENDIF
C
*     FUNCTION X2_0
      IF (T.LT.0.1) THEN
        X2_0=0
      ELSE
        X2_0=X2
      ENDIF
C
*     FUNCTION X3_0
      IF (T.LT.0.1) THEN
        X3_0=0
      ELSE
        X3_0=X3
      ENDIF
C
*     FUNCTION X4_0
      IF (T.LT.0.1) THEN
        X4_0=0
      ELSE
        X4_0=X4
      ENDIF
C
*     FUNCTION X5_0
      IF (T.LT.0.1) THEN
        X5_0=0
      ELSE
        X5_0=X5
      ENDIF
C
*     FUNCTION Y1_0
      IF (T.LT.0.1) THEN
        Y1_0=0
      ELSE
        Y1_0=Y1
      ENDIF
C
*     FUNCTION Y2_0
      IF (T.LT.0.1) THEN
        Y2_0=0
      ELSE
        Y2_0=Y2
      ENDIF
C
*     FUNCTION Y3_0
      IF (T.LT.0.1) THEN
        Y3_0=0
      ELSE
        Y3_0=Y3
      ENDIF
C
*     FUNCTION Y4_0
      IF (T.LT.0.1) THEN
        Y4_0=0
      ELSE
        Y4_0=Y4
      ENDIF
C
*     FUNCTION Y5_0
      IF (T.LT.0.1) THEN
        Y5_0=0
      ELSE
        Y5_0=Y5
      ENDIF
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION X1_fit
      X1_fit=X1
C
*     FUNCTION X2_fit
      X2_fit=X2
C
*     FUNCTION X3_fit
      X3_fit=X3
C
*     FUNCTION X4_fit
      X4_fit=X4
C
*     FUNCTION X5_fit
      X5_fit=X5
C
*     FUNCTION Y1_fit
      Y1_fit=Y1
C
*     FUNCTION Y2_fit
      Y2_fit=Y2
C
*     FUNCTION Y3_fit
      Y3_fit=Y3
C
*     FUNCTION Y4_fit
      Y4_fit=Y4
C
*     FUNCTION Y5_fit
      Y5_fit=Y5
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
