C
C------------------------------------------------------
C
C     Problem:    EQEX
C
C     Date:       12.02.01
C
C------------------------------------------------------
C 
*     REAL CONSTANT
      V1=10
      V2=10  
      X0=1
      Y0=0
      M=0.8
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      K, G, X1, Y1, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION X1P
      IF (T.LT.10) THEN
        L=1
      ELSE
        L=1.5
      ENDIF
      Q1=K*(X1-Y1/M)   
      X1P=(L*(X0-X1)-Q1)/V1   
C
*     FUNCTION Y1P
      Y1P=(G*(Y0-Y1)+Q1)/V2 
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION X1_0
      IF (T.LT.0.1) THEN
        X1_0=X0
      ELSE
        X1_0=X1
      ENDIF
C
*     FUNCTION Y1_0
      IF (T.LT.0.1) THEN
        Y1_0=Y0
      ELSE
        Y1_0=Y1
      ENDIF
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION X_fit
      X_fit=(X0-X1)/X0
C
*     FUNCTION X1_fit
      X1_fit=X1
C
*     FUNCTION Y1_fit
      Y1_fit=Y1
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
