C
C------------------------------------------------------
C
C     Problem:    ENZYM
C
C     Date:       15.09.97
C
C------------------------------------------------------
C
*     REAL CONSTANT
      pi = 3.14
      w = 4991/sqrt(2*pi)
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      p1, p2, p3, p4, y10, y20, y1, y2, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION y1_t
      if (t.gt.0) then
        y1_t = p1*(27.8 - y1) + p4*(y2 - y1)/2.6 + 
     /         w/t*exp(-0.5*((log(t) - p2)/p3)**2)
      else
        y1_t=0
      endif
C
*     FUNCTION y2_t
      y2_t = p4/2.7*(y1 - y2)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION y1_0
      y1_0 = y10
C
*     FUNCTION y2_0
      y2_0 = y20
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION y1_fit
      y1_fit = y1
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
