C
C------------------------------------------------------
C
C     Problem:    ENZTUBE
C
C     Date:       13.02.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      KM=0.5 
      A=0.5
      EPS=0.4  
      E0=3 
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      K, M, S, F, Z
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION SP
      E=E0+M*Z       
      VM=K*E        
      RS=VM*S/(KM+S) 
      VZ=F/(A*EPS)   
      SP=-(1/VZ)*RS  
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION S_0
      S_0=10
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION S_fit
      S_fit=S
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G
C      G = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
