C
C------------------------------------------------------
C
C     Problem:    ENZSPLIT
C
C     Date:       13.02.01
C
C------------------------------------------------------
C 
*     REAL CONSTANT
      DS = 3E-6
      E = 1.4E-3   
      KM = 3.2E-2
      KI = 9.4E-3  
      L = 0.01 
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      K, DP, S0, DSDX, S, X
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION DSDXP
      IF (S.LT.1) THEN
        P = (1-S)*DP*1E-6/DS 
      ELSE
        P = 0
      ENDIF
      R = K*E*S/(KM/S0)/(1+(S0*P/KI)+S) 
      DSDXP = L*L*R/DS/S0 
C
*     FUNCTION SP
      SP = DSDX  
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION DSDX_0
      DSDX_0 = 0
C
*     FUNCTION S_0
      S_0 = S0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION S_fit
      S_fit = S
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
*     FUNCTION G
      G = S-1
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
