C
C------------------------------------------------------
C
C     Problem:    ENZDYN
C
C     Date:       13.02.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      K=8.7
      K1=9.40E-03
      K2=3.20E-02
      P0=0
      S0=1 
      L=1.0E-02   
      PI=0
      SI=0 
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations(u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      D1, D2, E, S, P, S_x, P_x, S_xx, P_xx, x, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
C*     FUNCTION flux
C      flux = ...
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: all 
C     functions in first area, then all functions in
C     second area, etc.):
C
*     FUNCTION S_t
      Z1=K*E  
      Z2=K2/S0     
      Z3=S0/K1  
      R=Z1*S/(Z2*(1+Z3*P)+S)  
      S_t=D1*1E-6*S_xx - R
C
*     FUNCTION P_t
      P_t=D2*1E-6*P_xx + R
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: all initial values in 
C     first area, then all initial values in second 
C     area, etc.):
C
*     FUNCTION S_0
      S_0=SI
C
*     FUNCTION P_0
      P_0=PI
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations, order 
C     defined by increasing spatial positions:
C
C*     FUNCTION V
C      V=...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0 in the same order: 
C
C*     FUNCTION V_0
C      V_0=...
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
*     FUNCTION S_left
      S_left=S0
C
*     FUNCTION P_left
      P_left=P0
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an area, etc.:
C
*     FUNCTION S_x_right
      S_x_right=0
C
*     FUNCTION P_x_right
      P_x_right=0
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION S_fit
      S_fit=S
C
*     FUNCTION P_fit
      P_fit=P
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
