C
C------------------------------------------------------
C
C     Problem:    ENZCON
C
C     Date:       14.02.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      KM=0.5
      S0=10
      E0=3
      FS=2
      V=20 
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      KI, K2, FE, S1, P1, E1, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION S1P
      F1=FS+FE                     
      VM=E1*K2
      RS=-VM*S1/(KM+S1+(P1/KI))    
      RP=-2*RS
      S1P=(FS/V)*S0-(F1/V)*S1+RS  
C
*     FUNCTION P1P
      P1P=-(F1/V)*P1+RP   
C
*     FUNCTION E1P
      E1P=FE*E0/V-F1*E1/V
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION S1_0
      S1_0=0
C
*     FUNCTION P1_0
      P1_0=0
C
*     FUNCTION E1_0
      E1_0=0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION S1_fit
      S1_fit=S1
C
*     FUNCTION P1_fit
      P1_fit=P1
C
*     FUNCTION E1_fit
      E1_fit=E1
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G
C      G = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
