C
C------------------------------------------------------
C
C     Problem:  ENTERO
C
C     Date:     21.12.1993
C
C------------------------------------------------------
C
*     REAL CONSTANT
      d0 = 10
      tau = 4.2
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k12, k41, k23, k24, y1, y2, y3, y4, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION Y1P
      IF (T.Ge.TAU) THEN
        Y1P = -k12*y1 + k41*y4
      ELSE
        Y1P = -k12*y1
      ENDIF
c
*     FUNCTION Y2P
      Y2P = -(k23+k24)*y2 + k12*y1
c
*     FUNCTION Y3P
      Y3P = k23*y2
c
*     FUNCTION Y4P
      IF (T.Ge.TAU) THEN
        Y4P = -k41*y4 + k24*y2
      ELSE
        Y4P= k24*y2
      ENDIF
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION Y10
      if (t.lt.0.1) then
        y10 = d0
      else
        y10 = y1
      endif
C
*     function y20
      if (t.lt.0.1) then
        y20 = 0
      else
        y20 = y2
      endif
C
*     FUNCTION y30
      if (t.lt.0.1) then
        y230 = 0
      else
        y30 = y3
      endif
C
*     function y40
      if (t.lt.0.1) then
        y40 = 0
      else
        y40 = y4
      endif
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION Y2FIT
      Y2FIT = Y2
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
