C
C------------------------------------------------------
C
C     Problem:    ELEC_NET
C
C     Date:       18.10.2002
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind = 1..3
C
C------------------------------------------------------
C
*     TABLE L(i), i in ind
      1 10.0
      2 15.0
      3 8.0
C
*     TABLE R(i), i in ind
      1 1.0
      2 2.0
      3 3.0
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. concentration variable, if exists (c)
C     3. Laplace variable (s) corresponding to time
C        variable
C
*     VARIABLE
      M1(i), i in ind
      M2(i), i in ind
      s
C
C------------------------------------------------------
C
C   - Functions defining fitting criteria in the Laplace
C     space:
C
*     FUNCTION Z11
      Z11 = (70.63 + s*13.14) - SUM(s**2*M1(i)**2/(R(i) + s*L(i)), i in ind)
C
*     FUNCTION Z12
      Z12 = s*10.92 - SUM(s**2*M1(i)*M2(i)/(R(i) + s*L(i)), i in ind)  
C
*     FUNCTION Z22
      Z22 = (282.5 + s*14.58) - SUM(s**2*M2(i)**2/(R(i) + s*L(i)), i in ind)
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
