C
C------------------------------------------------------
C
C     Problem:    ELEC_DYN
C
C     Date:       20.06.1996
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (ux)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (uxx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. spatial variable (x)
C     7. time variable (t)
C
*     VARIABLE
      eps, p, eta, u, v, u_x, v_x, u_xx, v_xx, x, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION u_t
      z = u - v
      g = exp(eta*z/3) - exp(-2*eta*z/3)     
      u_t = eps*p*u_xx - g
C
*     FUNCTION v_t
      v_t = p*v_xx + g
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION u_0
      u_0 = 1
C
*     FUNCTION v_0
      v_0 = 0
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations:
C
c*     FUNCTION VP
c      VP = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0: 
C
c*     FUNCTION V0
c      V0 = ...
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     borders of all areas, then at right borders of all 
C     areas:
C
*     FUNCTION v_l
      v_l = 0
C
*     FUNCTION u_r
      u_r = 1
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left borders of all areas, then
C     at right borders of all areas:
C
*     FUNCTION u_xl
      u_xl = 0
C
*     FUNCTION v_xr
      v_xr = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION FIT1
      FIT1 = u
C
*     FUNCTION FIT2
      FIT2 = v
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


