C
C------------------------------------------------------
C
C     Problem:    ECOLOGY
C
C     Date:       21.6.1999
C
C------------------------------------------------------
C
*     REAL CONSTANT
      pi = 3.1415926535
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations, first the differential ones,
C        then the algebraic variables (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE equation, if at all.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      a, b, u, v, u_x, v_x, u_xx, v_xx, x, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
C*     FUNCTION flux
C      flux = ...
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: differential
C     followed by algebraic functions in first area, then
C     differential followed by algebraic functions in 
C     second area, etc.):
C
*     FUNCTION u_t
      u_t = a*u_xx + ((35 + 16*u - u**2)/9 - v)*u
C
*     FUNCTION v_t
      v_t = b*v_xx + (u - (5 + 2*v)/5)*v
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: initial values for 
C     differential followed by algebraic variables in 
C     first area, then differential followed by algebraic
C     variables in second area, etc.):
C
*     FUNCTION u_0
      if (x.lt.1) then
        u_0 = 5
      else
      if (x.lt.1.25) then
        u_0 = 4*x + 1
      else
      if (x.lt.1.5) then
        u_0 = -4*x + 11
      else
        u_0 = 5
      endif
      endif
      endif
C
*     FUNCTION v_0
      if (x.lt.1) then
        v_0 = 10
      else
      if (x.lt.1.25) then
        v_0 = 4*x + 6
      else
      if (x.lt.1.5) then
        v_0 = -4*x + 16
      else
        v_0 = 10
      endif
      endif
      endif
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations, order 
C     defined by increasing spatial positions:
C
c*     FUNCTION v_t
c      v_t = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0 in the same order: 
C
c*     FUNCTION v_0
c      v_0 = ...
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
c*     FUNCTION u_left
c      u_left = 0
C
c*     FUNCTION u_right
c      u_right = 0
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an area, etc.:
C
*     FUNCTION u_x_left
      u_x_left = 0
C
*     FUNCTION v_x_left
      v_x_left = 0
C
*     FUNCTION u_x_right
      u_x_right = 0
C
*     FUNCTION v_x_right
      v_x_right = 0
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION fit1_u
      fit1_u = u
C
*     FUNCTION fit1_v
      fit1_v = v
C
*     FUNCTION fit2_u
      fit2_u = u
C
*     FUNCTION fit2_v
      fit2_v = v
C
*     FUNCTION fit3_u
      fit3_u = u
C
*     FUNCTION fit3_v
      fit3_v = v
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


