C  
C------------------------------------------------------
C  
C     Problem:    EAR2MAR1
C  
C     Date:       22.12.2002
C  
C------------------------------------------------------
C                            
*     REAL CONSTANT
      acc = 0.1405
      beta = -0.07487      
      tscale = 3.32
C  
C------------------------------------------------------
C  
*     PARAMETER
      n = 8      
C  
C------------------------------------------------------
C  
*     INDEX
      i
C  
C------------------------------------------------------
C  
*     SET OF INDICES
      ind = 1..n              
C  
C------------------------------------------------------
C  
*     MACRO theta
      if (t.lt.t1) then
        theta = th(1) + th(2)*t + th(3)*t**2 + th(4)*t**3
      else
        theta = th(5) + th(6)*(t-t1) + th(7)*(t-t1)**2 + th(8)*(t-t1)**3
      endif  
C  
C------------------------------------------------------
C  
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      th(j), j in ind        
      rf, t1
      r, u, v, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION r_t
      r_t = u*tscale
C
*     FUNCTION u_t           
      accm = acc/(1 + beta*t*tscale)
      u_t = ((v**2 - 1/r)/r + accm*sin(theta))*tscale
C  
*     FUNCTION v_t
      v_t = (-u*v/r + accm*cos(theta))*tscale
C  
C------------------------------------------------------
C  
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C  
*     FUNCTION r_0
      if (t.lt.0.000001) then
        r_0 = 1
      else
        r_0 = r
      endif
C  
*     FUNCTION u_0
      if (t.lt.0.000001) then
        u_0 = 0
      else
        u_0 = u
      endif
C  
*     FUNCTION v_0
      if (t.lt.0.000001) then
        v_0 = 1
      else
        v_0 = v
      endif
C  
C------------------------------------------------------
C  
C   - Fitting criteria:
C  
*     FUNCTION theta_plot
      theta_plot = theta
C  
*     FUNCTION r_plot
      r_plot = r
C  
*     FUNCTION u_plot
      u_plot = u
C  
*     FUNCTION v_plot
      v_plot = v
C  
*     FUNCTION rf_plot
      rf_plot = rf
C  
C------------------------------------------------------
C
C   - Constraints (if exist):
C
*     FUNCTION g1
      g1 = r - rf
C
*     FUNCTION g2
      g2 = u
C
*     FUNCTION g3
      g3 = v - 1/sqrt(rf)             
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
