C
C------------------------------------------------------
C
C     Problem:    DUCT
C
C     Date:       28.01.2002
C
C------------------------------------------------------
C
*     REAL CONSTANT
      H = 1.14
      gamma = 1.4
      uin = 0.1
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      q, Ain, Aout, u, x
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION u_x
      B02 = (1 - x)**2
      B02_x = -2*(1 - x)
      B12 = 2*x*(1 - x)
      B12_x = 2 - 4*x
      B22 = x**2
      B22_x = 2*x
      A = Ain*B02 + q*B12 + Aout*B22
      A_x = Ain*B02_x + q*B12_x + Aout*B22_x
      u_x = -(A_x/A*((gamma-1)/(gamma+1)*u - H/(u+0.0001)))
     /              /(1 - H/(u+0.0001)**2)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION u_0
      u_0 = uin
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION fit
      fit = u
C
*     FUNCTION A_sim
      B02 = (1 - x)**2
      B02_x = -2*(1 - x)
      B12 = 2*x*(1 - x)
      B12_x = 2 - 4*x
      B22 = x**2
      B22_x = 2*x
      A = Ain*B02 + q*B12 + Aout*B22
      A_sim = A
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
