C
C------------------------------------------------------
C
C     Problem:    DUAL
C
C     Date:       13.02.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      UMAX=1.5
      S1FEED=3.5
      S2FEED=0.25  
      X0=1.0
      S10=1.0
      S20=1.0 
      Y1MIN=0.80
      Y1MAX=1.0
      Y2MIN=7.0
      Y2MAX=10.0
      B1=7.0
      B2=13.0
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      KS1, KS2, D, X, S1, S2, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION XP
      RAT=S1/S2
      IF (RAT .LT. B1) THEN
        GOTO 10
      ENDIF
      IF (RAT .GT. B2) THEN
        GOTO 20
      ENDIF
      S=(RAT-B1)/(B2-B1)
      YXS1=Y1MAX+S*(Y1MIN-Y1MAX)
      YXS2=Y2MIN+S*(Y2MAX-Y2MIN)
      GOTO 100 
   10 CONTINUE
      YXS1=Y1MAX
      YXS2=Y2MIN
      GOTO 100
   20 CONTINUE
      YXS1=Y1MIN
      YXS2=Y2MAX
      GOTO 100
  100 CONTINUE
      U=UMAX*(S1/(KS1+S1))*(S2/(KS2+S2))
      RX=U*X
      RS1=(-1/YXS1)*RX
      RS2=(-1/YXS2)*RX
      XP=-D*X+RX
C
*     FUNCTION S1P
      S1P=D*(S1FEED-S1)+RS1
C
*     FUNCTION S2P
      S2P=D*(S2FEED-S2)+RS2 
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION X_0
      X_0=X0
C
*     FUNCTION S1_0
      S1_0=S10
C
*     FUNCTION S2_0
      S2_0=S20
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION X_fit
      X_fit=X
C
*     FUNCTION S1_fit
      S1_fit=S1
C
*     FUNCTION S2_fit
      S2_fit=S2
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G
C      G = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
