C
C------------------------------------------------------
C
C     Problem:    DRY_FRI2
C
C     Date:       11.10.1999
C
C------------------------------------------------------
C
*     REAL CONSTANT
      N = 1
      m1 = 1
      m2 = 1
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      mue, t1, t2, t3, t4, p1, p2, v1, v2, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION p1_t
      p1_t = v1
C
*     FUNCTION p2_t
      p2_t = v2
C
*     FUNCTION v1_t
      if (t.lt.t1) then
        v = v1 - v2
      else
      if (t.lt.t2) then
        v = v2 - v1
      else
      if (t.lt.t3) then
        v = v1 - v2
      else
      if (t.lt.t4) then
        v = v2 - v1
      else
        v = v1 - v2
      endif
      endif
      endif
      endif
      f1 = sin(t)
      v1_t = (f1 - mue*N*v)/m1
C
*     FUNCTION v2_t
      f2 = 0
      v2_t = (f2 + mue*N*v)/m2
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION p1_0
      if (t.eq.0) then
        p1_0 = 1
      else
        p1_0 = p1
      endif
C
*     FUNCTION p2_0
      if (t.eq.0) then
        p2_0 = 1
      else
        p2_0 = p2
      endif
C
*     FUNCTION v1_0
      if (t.eq.0) then
        v1_0 = 0
      else
        v1_0 = v1
      endif
C
*     FUNCTION v2_0
      if (t.eq.0) then
        v2_0 = 0
      else
        v2_0 = v2
      endif
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION p1_fit
      p1_fit = p1
C
*     FUNCTION p2_fit
      p2_fit = p2
C
*     FUNCTION v1_fit
      v1_fit = v1
C
*     FUNCTION v2_fit
      v2_fit = v2
C
*     FUNCTION v21_fit
      v21_fit = v1 - v2
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
*     FUNCTION g1
      g1 = t2 - t1  
C
*     FUNCTION g2
      g2 = t3 - t2  
C
*     FUNCTION g3
      g3 = t4 - t3 
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

