C
C------------------------------------------------------
C
C     Problem:    DRY_FRIC
C
C     Date:       11.10.1999
C
C------------------------------------------------------
C
*     REAL CONSTANT
      N = 1
      m1 = 1
      m2 = 1
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      mue, p1, p2, v1, v2, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
C
*     FUNCTION p1_t
      p1_t = v1
C
*     FUNCTION p2_t
      p2_t = v2
C
*     FUNCTION v1_t
      f1 = sin(t)
      if (v1.gt.v2) then
        v1_t = (f1 - mue*N*(v1 - v2))/m1
      else
        v1_t = (f1 - mue*N*(v2 - v1))/m1
      endif
C
*     FUNCTION v2_t
      f2 = 0
      if (v1.gt.v2) then
        v2_t = (f2 + mue*N*(v1 - v2))/m2
      else
        v2_t = (f2 + mue*N*(v2 - v1))/m2
      endif
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION p1_0
      p1_0 = 1
C
*     FUNCTION p2_0
      p2_0 = 1
C
*     FUNCTION v1_0
      v1_0 = 0
C
*     FUNCTION v2_0
      v2_0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION p1_fit
      p1_fit = p1
C
*     FUNCTION p2_fit
      p2_fit = p2
C
*     FUNCTION v1_fit
      v1_fit = v1
C
*     FUNCTION v2_fit
      v2_fit = v2
C
*     FUNCTION v21_fit
      v21_fit = v1 - v2
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


