C
C------------------------------------------------------
C
C     Problem:    DRYER
C
C     Date:       06.05.98
C
C------------------------------------------------------
C
*     REAL CONSTANT   
      AA = 5.17
      a1 = 4235
      BA = 1717.48
      CA = 232.63
c      C1 = -32.93
c      C2 = 0.3184
c      C3 = -0.0011917
      ER = 5500
      p0 = 1.013
      cpD = 1.8
      cpG = 1
      cpS = 1.3
      cpW = 4.2
      delta_hv = 2500
      mS = 0.28
      mG = 0.28
      mueH2O = 18
      mueG = 29
      rhoSol = 600 
      Tref =50 + 273.15
      XS0 = 35
      XG0 = 33
      TS0 = 150
      TG0 = 20
C
C------------------------------------------------------
C
*     LININT Xborder
      0.0   0.0
      0.8   0.0001
      0.915 0.00025
      0.977 0.002
      1.0   0.01
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      C1, C2, C3, A, k, XS, XG, TS, TG, z
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION XS_z
      w0 = -AA - BA/(TG+CA)
      if (w0.gt.0) then
        phiG = p0/(1 + mueH2O/mueG/XG)*10**w0
      else
        phiG = p0
      endif
      if (XS.gt.0) then
        w1 = A*rhoSol/mS*(C1*XS**3 + C2*XS**2 + C3*XS)
     /       *DEXP(ER/Tref - ER/(TS+273.15))*DEXP(-ER/Tref)
     /       *(XS - Xborder(phiG))/XS
      else
        w1=0
      endif
      XS_z = w1
C
*     FUNCTION XG_z
      XG_z = mS/mG*w1
C
*     FUNCTION TS_z
      w2 = k*A*a1*(TG - TS)
      TS_z = (w2 + mS*w1*delta_hv)/(mS*(cpS + XS*cpW))
C
*     FUNCTION TG_z
      TG_z = w2/(mG*(cpG + XG*cpD))
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION XS_0
      XS_0 = XS0
C
*     FUNCTION XG_0
      XG_0 = XG0
C
*     FUNCTION TS_0
      TS_0 = TS0
C
*     FUNCTION TG_0
      TG_0 = TG0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION XS_fit
      XS_fit = XS
C
*     FUNCTION XG_fit
      XG_fit = XG
C
*     FUNCTION TS_fit
      TS_fit = TS
C
*     FUNCTION TG_fit
      TG_fit = TG
C
C------------------------------------------------------
C
C   - Constraints:
C
c*     FUNCTION g1
c      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C








