C
C------------------------------------------------------
C
C     Problem:    DRY
C
C     Date:       13.02.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      C0=2.000E-05
      U=1.000E-02
      A=100 
      T2=20
      T1=60     
      L=1     
      V=10
      RHO=5.000E-02
      CI=5.0000E-03  
      W=V*RHO             
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations(u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      D, H, C, C_x, C_xx, W1, W2, x, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
C*     FUNCTION flux
C      flux = ...
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: all 
C     functions in first area, then all functions in
C     second area, etc.):
C
*     FUNCTION C_t
      C_t=D*C_xx
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: all initial values in 
C     first area, then all initial values in second 
C     area, etc.):
C
*     FUNCTION C_0
      C_0=CI
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations, order 
C     defined by increasing spatial positions:
C
*     FUNCTION W1P
      W1P=U*A*(T1-T2)/H  
C
*     FUNCTION W2P             
      W2P=D*A*C_x              
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0 in the same order: 
C
*     FUNCTION W1_0
      W1_0=0
C
*     FUNCTION W2_0
      W2_0=0
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
*     FUNCTION C_left
      C_left=C0
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an area, etc.:
C
*     FUNCTION C_x_right
      C_x_right=0
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION P_fit
      W3=W1+W2    
      W4=W+A*L*C-W3      
      P_fit=W3*100/(W+A*L*C)  
C
*     FUNCTION R1_fit
      M1=U*A*(T1-T2)/H
      M2=A*D*C_x  
      R1_fit=M1+M2         
C
*     FUNCTION W1_fit
      W1_fit=W1
C
*     FUNCTION W2_fit
      W2_fit=W2
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
