C
C------------------------------------------------------
C
C     Problem:    DRUG_SCH
C
C     Date:       14.05.2002
C
C------------------------------------------------------
C
*     CONINT u
      0.0    0.0
      19.0  55.0
      20.0  12.0
      21.0   0.0
      49.0  55.0
      50.0  12.0
C
*     REAL CONSTANT
      k3 = 10
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k1, k2, k4, x1, x2, x3, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x1_t
      if (x2.ge.k3) then
        H = 1
      else
        H = 0
      endif
      x1_t = -k1*x1 + k2*(x2 - k3)*H
C
*     FUNCTION x2_t
      x2_t = u(t) - k4*x2
C
*     FUNCTION x3_t
      x3_t = x2
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x1_0
      if (t.lt.0.001) then
        x1_0 = log(100)
      else
        x1_0 = x1
      endif
C
*     FUNCTION x2_0
      if (t.lt.0.001) then
        x2_0 = 0
      else
        x2_0 = x2
      endif
C
*     FUNCTION x3_0
      if (t.lt.0.001) then
        x3_0 = 0
      else
        x3_0 = x3
      endif
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION x1_fit
      x1_fit = x1
C
*     FUNCTION x2_fit
      x2_fit = x2
C
*     FUNCTION x3_fit
      x3_fit = x3
C
*     FUNCTION ctrl
      ctrl = u(t)
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
