C
C------------------------------------------------------
C
C     Problem:    DRUGDIS2
C
C     Date:       04.06.2002
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      tf, t1, t2, t3,  x1, x2, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x1_t
      if (t.le.t1) then
        u = 8
      else
      if (t.le.t2) then
        u = 0
      else
      if (t.le.t3) then
        u = 8
      else
        u = 0
      endif 
      endif
      endif
      g2 = 1 + 0.2*(x1 + x2)
      g3 = g2**2 + 232 + 46.4*x2 
      g4 = g2**2 + 232 + 46.4*x1
      g1 = g2**2/(g3*g4 - 2152.96*x1*x2) 
      x1_t = tf*g1*(g4*(0.02 - x1) + 46.4*(u - 2*x2))
C
*     FUNCTION x2_t
      x2_t = tf*g1*(g3*(u - 2*x2) + 46.4*(0.02 - x1))
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x1_0
      if (t.lt.0.0001) then
        x1_0 = 0.02
      else
        x1_0 = x1
      endif
C
*     FUNCTION x2_0
      if (t.lt.0.0001) then
        x2_0 = 0
      else
        x2_0 = x2
      endif
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION x1_fit
      x1_fit = x1
C
*     FUNCTION x2_fit
      x2_fit = x2
C
*     FUNCTION tf_fit
      tf_fit = tf/1000
C
*     FUNCTION u_ctrl
      if (t.le.t1) then
        u = 8
      else
      if (t.le.t2) then
        u = 0
      else
      if (t.le.t3) then
        u = 8
      else
        u = 0
      endif 
      endif
      endif
      u_ctrl = u
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
*     FUNCTION r1
      r1 = t2 - t1 - 0.00001
C
*     FUNCTION r2
      r2 = t3 - t2 - 0.00001
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

