C
C------------------------------------------------------
C
C     Problem:    DMDS
C
C     Date:       19.12.99
C
C------------------------------------------------------
C
*     REAL CONSTANT
      s1 = 1E-3
      s2 = 1E-4
      s3 = 1E-5
      s4 = 1E-6
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      b1, b2, b3, b4, a1, a2, a3, a4
      Me, MT, DMS, DMDS, T, time
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION Me_t
      nom1 = 503.3*(1/(T+273.15) - 1/403.15)
      r1 = b1*s1*exp(-a1*nom1)
      r2 = b2*s2*exp(-a2*nom1)
      r3 = b3*s3*exp(-a3*nom1)  
      r4 = b4*s4*exp(-a4*nom1)
      y1 = Me
      y2 = MT
      y3 = DMS
      y4 = DMDS
      if (y1.lt.0.0001) then 
        y1 = 0.0001
      endif
      if (y2.lt.0.0001) then 
        y2 = 0.0001
      endif
      if (y3.lt.0.0001) then 
        y3 = 0.0001
      endif
      if (y4.gt.99.9999) then 
        y4 = 99.9999
      endif
      r1 = r1*y4
      r2 = r2*y2
      r3 = r3*y2
      r4 = r4*y3
      Me_t =  r2 + r4
C
*     FUNCTION MT_t
      MT_t = r1 - r2 - r3
C
*     FUNCTION DMS_t
      DMS_t = r3 - r4
C
*     FUNCTION DMDS_t
      DMDS_t = -r1
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION Me_0
      Me_0 = 0
C
*     FUNCTION MT_0
      MT_0 = 0
C
*     FUNCTION DMS_0
      DMS_0 = 0
C
*     FUNCTION DMDS_0
      DMDS_0 = 100
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION Me_fit
      Me_fit = Me
C
*     FUNCTION MT_fit
      MT_fit = MT
C
*     FUNCTION DMS_fit
      DMS_fit = DMS
C
*     FUNCTION DMDS_fit
      DMDS_fit = DMDS
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

