C
C------------------------------------------------------
C
C     Problem:    DLA5
C
C     Date:       12.8.2004
C
C------------------------------------------------------
C
*     REAL CONSTANT
      l10 = 0.4
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k1p, k1m, r0, k2p, k2m, l20, y10, y20, y1, y2, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION y1P   
      y1p = k1p*(r0-y1-y2)*(l10-y1) - k1m*y1
c
*     FUNCTION y2p
      y2p = k2p*(r0-y1-y2)*(l20-y2) - k2m*y2        
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION y1_0
      y1_0 = y10
C
*     FUNCTION y2_0
      y2_0 = y20
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION y1_fit
      y1_fit = y1
C
*     FUNCTION y2_fit
      y2_fit = y2
C
*     FUNCTION y1p_0
      y1p_0 = k1p*(r0-y10-y20)*(l10-y10) - k1m*y10
C
*     FUNCTION y2p_0
      y2p_0 = k2p*(r0-y10-y20)*(l20-y20) - k2m*y20   
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

