C
C------------------------------------------------------
C
C     Problem:    DIS_KIN2
C
C     Date:       15.10.2004
C
C------------------------------------------------------
C
*     REAL CONSTANT
      l10 = 0.207469
      l2  = 1.01
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k1p, kdr, r0, kr, k1, k2, KD, k2p, kr1, z
      y1, y2, y12, y22, y32, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
c
*     FUNCTION Y1P
      Y1P = k1p*(r0*exp(kr*t) - y1)*(l10 - y1) 
     /               - (k1p*KDR + k1)*y1 + k2*y2
C
*     FUNCTION Y2P
      Y2P = k1*y1 - k2*y2
C
C------------------------------------------------------
*     FUNCTION Y12P
      Y12P=k1p*(z*r0*exp(kr1*t) - y12 - y22)*(l10 - y12)
     /               - (k1p*KDR+k1)*y12 + k2*y32
C
*     FUNCTION Y22P
      Y22P = k2p*(z*r0*exp(kr1*t) - y12 - y22)*(l2 - y22)
     /               - k2p*KD*y22
C
*     FUNCTION Y32P
      Y32P = k1*y12 - k2*y32
C
C------------------------------------------------------
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION Y10
      Y10 = 0
C
*     FUNCTION Y20
      Y20 = 0
C
*     FUNCTION Y120
      Y120 = 0
C
*     FUNCTION Y220
      Y220 = 0
C
*     FUNCTION Y320
      Y320 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION Y1FIT
      Y1FIT = Y1
C
*     FUNCTION Y12FIT
      Y12FIT = Y12
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C