C
C------------------------------------------------------
C
C     Problem:    DISTPAR1
C
C     Date:       20.11.2002
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      a1, a2, a3, a4, a5, a6, a7, a8
      b1, b2, b3, b4, b5, b6, b7, b8, b9
      x, y, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x_t
      w = a3*x
      if (w.gt.10) then
        w = 10
      endif
      x_t = a1*sin(a2*y)*exp(w) + a4*x**2*y + a5*log(x**2*y**4+1e-5) + a6*cos(a7*x+a8*y)
C
*     FUNCTION y_t
      w = b3*y
      if (w.gt.10) then
        w = 10
      endif
      y_t = b1*cos(b2*x)/(exp(w)+b4*y**2) + b5*x**3*y + b6*atan(b7*x+b8*y**2) 
     /            + b9*sqrt(x**2+y**2)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x_0
      x_0 = -0.5
C
*     FUNCTION y_0
      y_0 = 0.5
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION x_fit
      x_fit = x
C
*     FUNCTION y_fit
      y_fit = y
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
