C
C------------------------------------------------------
C
C     Problem:    DISTILL3
C
C     Date:       05.01.1995
C
C------------------------------------------------------
C
*     PARAMETER
      N1  = 20
      N2  = 4
      N3  = 5
      N4  = 9
      N5  = 9
      NT  = 53
      NVD = 42
C
C------------------------------------------------------
C
*     SET OF INDICES
      IND1 = 1..N1
      IND2 = 1..N2
      IND3 = 1..N3
      IND4 = 1..N4
      IND5 = 1..N5
      INDT = 1..NT
C
C------------------------------------------------------
C
*     INDEX
      K
C
C------------------------------------------------------
C
*     REAL CONSTANT
      S      = 1.0
      F      = 200.0
      X1F    = 0.3
      X2F    = 0.1
      QEL    = 5.57
      RHK    = 0.83973
      RSK    = 0.793
      P0     = 1.0
      P      = 800.0
      H1     = 33.071
      H2     = 36.954
      H3     = 42.678
      GAMMA1 = 1.0
      GAMMA2 = 1.0
      GAMMA3 = 1.0
      N1MOL  = 1.365
      N2MOL  = 1.048
      N3MOL  = 0.972
      N4MOL  = 0.894
      N5MOL  = 0.2
      NVDMOL = 30.3
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. variables identifying solution of corresponding
C        algebraic equations (z)
C     4. concentration variable, if exists (c)
C     5. time variable (t)
C
*     VARIABLE
      A1, B1, C1, A2, B2, C2, A3, B3, C3
      X1(J), J IN INDT
      X2(J), J IN INDT
      T(J), J IN INDT
      TIME
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION X1P1
      K    = NVD
      D5   = 100.0
      D4   = QEL*S*3600/(X1(K)*H1 + X2(K)*H2 + (S - X1(K) - X2(K))*H3)
      D3   = D4 - D5
      D2   = D3
      D1   = D3
      L1   = RHK*D1
      L5   = RSK*D5
      L2   = L1 + F
      L3   = L1 + F
      L4   = L1 + F + L5
      X1P1 = D1*(GAMMA1*X1(2)*P0/P*DEXP(A1-B1/(C1+T(2))) - X1(1))/N1MOL
C
*     FUNCTION X2P1(J), J IN IND1
      K       = J + 1
      X2P1(J) = (L1*(X1(K-1) - X1(K)) +
     /         D1*GAMMA1*P0/P*(X1(K+1)*DEXP(A1-B1/(C1+T(K+1))) -
     /         X1(K)*DEXP(A1-B1/(C1+T(K)))))/N1MOL
C
*     FUNCTION X3P1
      K    = 22
      X3P1 = (L1*(X1(K-1) - X1(K)) + D2*GAMMA1*P0/P*
     /          (X1(K+1)*DEXP(A1 -B1/(C1+T(K+1))) -
     /          X1(K)*DEXP(A1-B1/(C1+T(K))))+F*(X1F*S-X1(K)))/N2MOL
C
*     FUNCTION X4P1(J), J IN IND2
      K       = J + 22
      X4P1(J) = (L2*(X1(K - 1) - X1(K)) +
     /            D2*GAMMA1*P0/P*(X1(K+1)*DEXP(A1-B1/(C1+T(K+1))) -
     /            X1(K)*DEXP(A1-B1/(C1+T(K)))))/N2MOL
C
*     FUNCTION X5P1(J), J IN IND3
      K       = J + 26
      X5P1(J) = (L3*(X1(K-1) - X1(K)) +
     /           D3*GAMMA1*P0/P*(X1(K+1)*DEXP(A1-B1/(C1+T(K+1))) -
     /           X1(K)*DEXP(A1-B1/(C1+T(K)))))/N3MOL
C
*     FUNCTION X6P1
      K    = 32
      X6P1 = (L3*(X1(K-1) - X1(K)) + L5*(X1(53) - X1(K)) +
     /        D4*GAMMA1*P0/P*(X1(K+1)*DEXP(A1-B1/(C1+T(K+1))) -
     /        X1(K)*DEXP(A1-B1/(C1+T(K)))))/N4MOL
C
*     FUNCTION X7P1(J), J IN IND4
      K       = J + 32
      X7P1(J) = (L4*(X1(K-1) - X1(K)) +
     /          D4*GAMMA1*P0/P*(X1(K+1)*DEXP(A1-B1/(C1+T(K+1))) -
     /          X1(K)*DEXP(A1-B1/(C1+T(K)))))/N4MOL
C
*     FUNCTION X8P1
      K    = NVD
      X8P1 = (L4*(X1(K-1) - X1(K)) - D4*(GAMMA1*P0/P*
     /        X1(K)*DEXP(A1-B1/(C1+T(K))) - X1(K)))/NVDMOL
C
*     FUNCTION X9P1
      X9P1 = D5*(X1(44)*GAMMA1*P0/P*
     /         DEXP(A1-B1/(C1+T(44))) - X1(43))/N5MOL
C
*     FUNCTION X10P1(J), J IN IND5
      K        = J + 43
      X10P1(J) = (L5*(X1(K-1) - X1(K)) +
     /            D5*GAMMA1*P0/P*(X1(K+1)*DEXP(A1-B1/(C1+T(K+1))) -
     /            X1(K)*DEXP(A1-B1/(C1+T(K)))))/N5MOL
C
*     FUNCTION X11P1
      K     = 53
      X11P1 = (L5*(X1(K-1) - X1(K)) +
     /         D5*GAMMA1*P0/P*(X1(32)*DEXP(A1-B1/(C1+T(32))) -
     /         X1(K)*DEXP(A1-B1/(C1+T(K)))))/N5MOL
C
*     FUNCTION X1P2
      X1P2 = D1*(GAMMA2*X2(2)*P0/P*DEXP(A2-B2/(C2+T(2))) - X2(1))/
     /        N1MOL
C
*     FUNCTION X2P2(J), J IN IND1
      K       = J + 1
      X2P2(J) = (L1*(X2(K-1) - X2(K)) +
     /           D1*GAMMA2*P0/P*(X2(K+1)*DEXP(A2-B2/(C2+T(K+1))) -
     /           X2(K)*DEXP(A2-B2/(C2+T(K)))))/N1MOL
C
*     FUNCTION X3P2
      K    = 22
      X3P2 = (L1*(X2(K-1) - X2(K)) + D2*GAMMA2*P0/P*
     /        (X2(K+1)*DEXP(A2-B2/(C2+T(K+1))) -
     /         X2(K)*DEXP(A2-B2/(C2+T(K)))) + F*(X2F*S - X2(K)))/N2MOL
C
*     FUNCTION X4P2(J), J IN IND2
      K       = J + 22
      X4P2(J) = (L2*(X2(K-1) - X2(K)) +
     /           D2*GAMMA2*P0/P*(X2(K+1)*DEXP(A2-B2/(C2+T(K+1))) -
     /           X2(K)*DEXP(A2-B2/(C2+T(K)))))/N2MOL
C
*     FUNCTION X5P2(J), J IN IND3
      K       = J+26
      X5P2(J) = (L3*(X2(K-1) - X2(K)) +
     /           D3*GAMMA2*P0/P*(X2(K+1)*DEXP(A2-B2/(C2+T(K+1))) -
     /           X2(K)*DEXP(A2-B2/(C2+T(K)))))/N3MOL
C
*     FUNCTION X6P2
      K    = 32
      X6P2 = (L3*(X2(K-1) - X2(K)) + L5*(X2(53) - X2(K)) +
     /        D4*GAMMA2*P0/P*(X2(K+1)*DEXP(A2-B2/(C2+T(K+1))) -
     /        X2(K)*DEXP(A2-B2/(C2+T(K)))))/N4MOL
C
*     FUNCTION X7P2(J), J IN IND4
      K       = J + 32
      X7P2(J) = (L4*(X2(K-1) - X2(K)) +
     /           D4*GAMMA2*P0/P*(X2(K+1)*DEXP(A2-B2/(C2+T(K+1))) -
     /           X2(K)*DEXP(A2-B2/(C2+T(K)))))/N4MOL
C
*     FUNCTION X8P2
      K    = NVD
      X8P2 = (L4*(X2(K-1) - X2(K)) - D4*(GAMMA2*P0/P*
     /        X2(K)*DEXP(A2-B2/(C2+T(K))) - X2(K)))/NVDMOL
C
*     FUNCTION X9P2
      X9P2 = D5*(X2(44)*GAMMA2*P0/P*
     /       DEXP(A2-B2/(C2+T(44))) - X2(43))/N5MOL
C
*     FUNCTION X10P2(J), J IN IND5
      K        = J+43
      X10P2(J) = (L5*(X2(K-1) - X2(K)) +
     /            D5*GAMMA2*P0/P*(X2(K+1)*DEXP(A2-B2/(C2+T(K+1))) -
     /            X2(K)*DEXP(A2-B2/(C2+T(K)))))/N5MOL
C
*     FUNCTION X11P2
      K     = 53
      X11P2 = (L5*(X2(K-1) - X2(K)) +
     /        D5*GAMMA2*P0/P*(X2(32)*DEXP(A2-B2/(C2+T(32))) -
     /        X2(K)*DEXP(A2-B2/(C2+T(K)))))/N5MOL
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     algebraic equations:
C
*     FUNCTION TEMPEQ(J), J IN INDT
      TEMPEQ(J) = -S + GAMMA1*P0/P*X1(J)*DEXP(A1-B1/(C1+T(J))) +
     /           GAMMA2*P0/P*X2(J)*DEXP(A2-B2/(C2+T(J))) +
     /           GAMMA3*P0/P*(S-X1(J)-X2(J))*DEXP(A3-B3/(C3+T(J)))
C
C------------------------------------------------------
C
C   - Initial values for solving systems of algebraic
C     equations (t=0):
C
*     FUNCTION X10(I), I IN INDT
      X10(I) = 0
C
*     FUNCTION X20(I), I IN INDT
      X20(I) = 0
C
*     FUNCTION T0(I), I IN INDT
      T0(I) = B3/(A3 - LOG(P/(GAMMA3*P0))) - C3
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION FIT2
      FIT2 = X1(53)/S
C
*     FUNCTION FIT3
      FIT3 = X2(42)/S
C
*     FUNCTION FIT4
      FIT4 = X2(53)/S
C
*     FUNCTION FIT5
      FIT5 = T(42)
C
*     FUNCTION FIT6
      FIT6 = T(53)
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C














