C
C------------------------------------------------------
C
C     Problem:    DISTILL
C
C     Date:       22.02.1995
C
C------------------------------------------------------
C
*     PARAMETER
      NVD  = 22
      NZL  = 11
      NZL2 = 9
      NVD2 = 10
C
C------------------------------------------------------
C
*     SET OF INDICES
      INDBOD = 1..NVD
      INDBZL = 1..NZL2
      INDAZL = 1..NVD2
C
C------------------------------------------------------
C
*     INDEX
      K
C
C------------------------------------------------------
C
*     REAL CONSTANT
      F = 200.0
      X1F = 0.46
      R = 0.8
      QEL = 5.0
      NMOLVD = 30
      A1 = 18.6071
      A2 = 19.2932
      B1 = 3643.314
      B2 = 4117.07
      C1 = -33.43
      C2 = -45.722
      P = 800
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. variables identifying solution of corresponding
C        algebraic equations (z)
C     4. concentration variable, if exists (c)
C     5. time variable (t)
C
*     VARIABLE
      H1, H2, A12
      X(I), I IN INDBOD
      TEMP(I), I IN INDBOD
      IFIT, TIME
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION X1P
      K = NVD
      D = QEL/(X(K)*H1 + (1-X(K))*H2)*3600.0
      LV = R*D
      LA = LV + F
      Y2 = A12*X(2)/((A12 - 1.0)*X(2) + 1.0)
      X1P = D*(Y2 - X(1))
C
*     FUNCTION XBZLP(I), I IN INDBZL
      K = I+1
      YK = A12*X(K)/((A12 - 1.0)*X(K) + 1.0)
      YK1 = A12*X(K+1)/((A12 - 1.0)*X(K+1) + 1.0)
      XBZLP(I) = LV*(X(K-1) - X(K)) + D*(YK1 - YK)
C
*     FUNCTION XZLP
      K = NZL
      YZL = A12*X(K)/((A12 - 1.0)*X(K) + 1.0)
      YZL1 = A12*X(K+1)/((A12 - 1.0)*X(K+1) + 1.0)
      XZLP = LV*(X(K-1) - X(K)) + D*(YZL1 - YZL) +
     /       F*(X1F - X(K))
C
*     FUNCTION XAZLP(I), I IN INDAZL
      K = NZL+I
      YK = A12*X(K)/((A12 - 1.0)*X(K) + 1.0)
      YK1 = A12*X(K+1)/((A12 - 1.0)*X(K+1) + 1.0)
      XAZLP(I) = LA*(X(K-1) - X(K)) + D*(YK1 - YK)
C
*     FUNCTION XVDP
      K = NVD
      YVD = A12*X(K)/((A12 - 1.0)*X(K) + 1.0)
      XVDP = (LV*(X(K-1) - X(K)) - D*(YVD - X(K)))/NMOLVD
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     algebraic equations:
C
*     FUNCTION TEMPEQ(I), I IN INDBOD
      Y1 = X(I)*DEXP(A1 - B1/(C1+TEMP(I)))/P
      Y2 = (1.0 - X(I))*DEXP(A2 - B2/(C2+TEMP(I)))/P
      TEMPEQ(I) = -1 + Y1 + Y2
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION X0(I), I IN INDBOD
      X0(I) = 1.0
C
C------------------------------------------------------
C
C   - Initial values for solving systems of algebraic
C     equations (t=0):
C
*     FUNCTION TEMP0(I), I IN INDBOD
      TEMP0(I) = B1/(A1 - LOG(P)) - C1
C
C------------------------------------------------------
C
C   - Fitting criterion:
C
*     FUNCTION FITX
      K=1
 1100 CONTINUE
      IF (K.GE.IFIT-0.1) THEN
        GOTO 1000
      ENDIF
      K=K+1
      GOTO 1100
 1000 CONTINUE
      FITX = X(K)
C
*     FUNCTION FITY
      K=1
 2100 CONTINUE
      IF (K.GE.IFIT-0.1) THEN
        GOTO 2000
      ENDIF
      K=K+1
      GOTO 2100
 2000 CONTINUE
      FITY = A12*X(K)/((A12 - 1.0)*X(K) + 1.0)
C
*     FUNCTION FIT_TEMP
      K=1
 3100 CONTINUE
      IF (K.GE.IFIT-0.1) THEN
        GOTO 3000
      ENDIF
      K=K+1
      GOTO 3100
 3000 CONTINUE
      FIT_TEMP = TEMP(K) - 273.15
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

