C
C------------------------------------------------------
C
C     Problem:    DISSOC
C
C     Date:       29.07.1994
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      K1, a1, a2, a3, t0, te, ys, tlag, Y1, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION Y1P
      if (t.le.tlag) then
        y1p=0
      else 
        VER = (a2/(t-tlag))*exp(-a3*(log(t-tlag)-t0)**2)
        Y1P = (a1+VER)*k1*(ys-y1)*(1-y1/te)
      endif
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION Y10
      Y10 = 0
C
C------------------------------------------------------
C
C   - Fitting criterion:
C
*     FUNCTION Y1FIT
      Y1FIT = Y1
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
