C
C------------------------------------------------------
C
C     Problem:    DISRET_0 
C
C     Date:       18.04.1996
C
C------------------------------------------------------
C
*     REAL CONSTANT 
      L = 100.0
      CA0 = 0.5
      T0 = 637.0
      U = 0.3
      RHO = 60.0
      HR = -36000.0
      CP = 0.8
      EA = 40000.0 
      ZF = 12000.0
      R = 3.577
      DZ = 0.125
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      D, LAMBDA
      CC1, CC2, CC3, CC4, CC5, CC6, CC7, CC8
      TT1, TT2, TT3, TT4, TT5, TT6, TT7, TT8
      t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION CC1t
      ALPHA = LAMBDA/(RHO*CP)
      B1 = ZF*L*L/D
      B2 = HR*CA0/(RHO*CP*T0)
      E = EA/(R*T0)
      P1 = U*L/D
      P2 = U*L/ALPHA
      if (TT1.gt.0) then
        R1 = B1*CC1*EXP(-E/TT1) 
      else
        R1 = 0
      endif
      if (TT2.gt.0) then
        R2 = B1*CC2*EXP(-E/TT2) 
      else
        R2 = 0
      endif
      if (TT3.gt.0) then
        R3 = B1*CC3*EXP(-E/TT3) 
      else
        R3 = 0
      endif
      if (TT4.gt.0) then
        R4 = B1*CC4*EXP(-E/TT4) 
      else
        R4 = 0
      endif
      if (TT5.gt.0) then
        R5 = B1*CC5*EXP(-E/TT5) 
      else
        R5 = 0
      endif
      if (TT6.gt.0) then
        R6 = B1*CC6*EXP(-E/TT6) 
      else
        R6 = 0
      endif
      if (TT7.gt.0) then
        R7 = B1*CC7*EXP(-E/TT7) 
      else
        R7 = 0
      endif
      if (TT8.gt.0) then  
        R8 = B1*CC8*EXP(-E/TT8) 
      else
        R8 = 0
      endif
      CC0 = 1.0
      CC1t = (CC0-2*CC1+CC2)/(DZ*DZ) + P1*(CC0-CC1)/DZ - R1   
C
*     FUNCTION CC2t
      CC2t = (CC1-2*CC2+CC3)/(DZ*DZ) + P1*(CC1-CC2)/DZ - R2   
C
*     FUNCTION CC3t
      CC3t = (CC2-2*CC3+CC4)/(DZ*DZ) + P1*(CC2-CC3)/DZ - R3   
C
*     FUNCTION CC4t
      CC4t = (CC3-2*CC4+CC5)/(DZ*DZ) + P1*(CC3-CC4)/DZ - R4   
C
*     FUNCTION CC5t
      CC5t = (CC4-2*CC5+CC6)/(DZ*DZ) + P1*(CC4-CC5)/DZ - R5   
C
*     FUNCTION CC6t
      CC6t = (CC5-2*CC6+CC7)/(DZ*DZ) + P1*(CC5-CC6)/DZ - R6   
C
*     FUNCTION CC7t
      CC7t = (CC6-2*CC7+CC8)/(DZ*DZ) + P1*(CC6-CC7)/DZ - R7   
C
*     FUNCTION CC8t
      CC9 = CC8
      CC8t = (CC7-2*CC8+CC9)/(DZ*DZ) + P1*(CC7-CC8)/DZ - R8   
C
*     FUNCTION TT1t
      TT0 = 1.0
      TT1t = ALPHA/D*(TT0-2*TT1+TT2)/(DZ*DZ) +
     /       P2*(TT0-TT1)/DZ - B2*R1  
C
*     FUNCTION TT2t
      TT2t = ALPHA/D*(TT1-2*TT2+TT3)/(DZ*DZ) + 
     /       P2*(TT1-TT2)/DZ - B2*R2  
C
*     FUNCTION TT3t
      TT3t = ALPHA/D*(TT2-2*TT3+TT4)/(DZ*DZ) + 
     /       P2*(TT2-TT3)/DZ - B2*R3  
C
*     FUNCTION TT4t
      TT4t = ALPHA/D*(TT3-2*TT4+TT5)/(DZ*DZ) + 
     /       P2*(TT3-TT4)/DZ - B2*R4  
C
*     FUNCTION TT5t
      TT5t = ALPHA/D*(TT4-2*TT5+TT6)/(DZ*DZ) + 
     /       P2*(TT4-TT5)/DZ - B2*R5  
C
*     FUNCTION TT6t
      TT6t = ALPHA/D*(TT5-2*TT6+TT7)/(DZ*DZ) + 
     /       P2*(TT5-TT6)/DZ - B2*R6  
C
*     FUNCTION TT7t
      TT7t = ALPHA/D*(TT6-2*TT7+TT8)/(DZ*DZ) + 
     /       P2*(TT6-TT7)/DZ - B2*R7  
C
*     FUNCTION TT8t
      TT9 = TT8
      TT8t = ALPHA/D*(TT7-2*TT8+TT9)/(DZ*DZ) + 
     /       P2*(TT7-TT8)/DZ - B2*R8  
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION CC10
      CC10 = 0.0
C
*     FUNCTION CC20
      CC20 = 0.0
C
*     FUNCTION CC30
      CC30 = 0.0
C
*     FUNCTION CC40
      CC40 = 0.0
C
*     FUNCTION CC50
      CC50 = 0.0
C
*     FUNCTION CC60
      CC60 = 0.0
C
*     FUNCTION CC70
      CC70 = 0.0
C
*     FUNCTION CC80
      CC80 = 0.0
C
*     FUNCTION TT10
      TT10 = 1.0
C
*     FUNCTION TT20
      TT20 = 1.0
C
*     FUNCTION T30
      TT30 = 1.0
C
*     FUNCTION TT40
      TT40 = 1.0
C
*     FUNCTION TT50
      TT50 = 1.0
C
*     FUNCTION TT60
      TT60 = 1.0
C
*     FUNCTION TT70
      TT70 = 1.0
C
*     FUNCTION TT80
      TT80 = 1.0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION FITC1
      FITC1 = CC1
C
*     FUNCTION FITC2
      FITC2 = CC2
C
*     FUNCTION FITC4
      FITC4 = CC4
C
*     FUNCTION FITC8
      FITC8 = CC8
C
*     FUNCTION FITT1
      FITT1 = TT1
C
*     FUNCTION FITT2
      FITT2 = TT2
C
*     FUNCTION FITT4
      FITT4 = TT4
C
*     FUNCTION FITT8
      FITT8 = TT8
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
