C
C------------------------------------------------------
C
C     Problem:    DISRET 
C
C     Date:       18.04.1996
C
C------------------------------------------------------
C
*     REAL CONSTANT 
      L      = 100.0        
      CA0    = 0.5
      T0     = 637.0  
      U      = 0.3 
      RHO    = 60.0  
      HR     = -36000.0
      CP     = 0.8 
      EA     = 40000.0 
      ZF     = 1.2E4  
      R      = 3.577 
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations, first the differential ones,
C        then the algebraic variables (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE equation, if at all.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      D, LAMBDA, CA, TEMP, CAz, TEMPz, CAzz, TEMPzz, z, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: differential
C     followed by algebraic functions in first area, then
C     differential followed by algebraic functions in 
C     second area, etc.):
C
*     FUNCTION CAt
      ALPHA = LAMBDA/(RHO*CP)
      B1 = ZF*L*L/D
      B2 = HR*CA0/(RHO*CP*T0)
      P1 = U*L/D
      P2 = U*L/ALPHA
      R1 = B1*CA*EXP(-EA/(R*T0*TEMP))
      CAt = CAzz - P1*CAz - R1
C
*     FUNCTION TEMPt
      TEMPt = ALPHA/D*TEMPzz - P2*TEMPz - B2*R1
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: initial values for 
C     differential followed by algebraic variables in 
C     first area, then differential followed by algebraic
C     variables in second area, etc.):
C
*     FUNCTION CA_0
      CA_0 = 0.0
C
*     FUNCTION TEMP_0
      TEMP_0 = 1.0
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
*     FUNCTION CA_left
      CA_left = 1.0
C
*     FUNCTION TEMP_left
      TEMP_left = 1.0
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an areas, etc.:
C
*     FUNCTION  CAz_right
      CAz_right = 0.0
C
*     FUNCTION TEMPz_right
      TEMPz_right = 0.0
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION FIT1
      FIT1 = CA
C
*     FUNCTION FIT2
      FIT2 = TEMP
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
