C
C------------------------------------------------------
C
C     Problem:    DISPLMNT
C
C     Date:       15.10.1997
C
C------------------------------------------------------
C
*     REAL CONSTANT
      L1=500
C
C----------------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k1p, k1m, r0, k2p, k2m, k, k13, k31, y1, y2, y3, L, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION y1p
      y1p=k1p*(r0*exp(-k*t)-y1-y2)*(L1-y1) - (k1m+k13)*y1
     /                                              + k31*y3
C
*     FUNCTION y2p
      y2p=k2p*(r0*exp(-k*t)-y1-y2)*(L-y2) - k2m*y2
C
*     FUNCTION y3p
      y3p=k13*y1 - k31*y3
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION y10
      y10=0
C
*     FUNCTION y20
      y20=0
C
*     FUNCTION y30
      y30=0
C
C------------------------------------------------------
C
C   - Fitting criterion:
C
*     FUNCTION FIT1
      FIT1=y1
C
*     FUNCTION FIT2
      FIT2=y2
C
*     FUNCTION FIT3
      FIT3=y3 
C
*     FUNCTION FIT4
      FIT4=r0 - y1 - y2
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
